/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.formatter;

import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.glassfish.main.jul.cfg.LogProperty;
import org.glassfish.main.jul.env.LoggingSystemEnvironment;
import org.glassfish.main.jul.formatter.ExcludeFieldsSupport;
import org.glassfish.main.jul.formatter.FormatterConfigurationHelper;
import org.glassfish.main.jul.formatter.GlassFishLogFormatter;
import org.glassfish.main.jul.formatter.HandlerId;
import org.glassfish.main.jul.record.GlassFishLogRecord;

public class UniformLogFormatter
extends GlassFishLogFormatter {
    private static final int REC_BUFFER_CAPACITY = 512;
    private static final String MULTILINE_INDENTATION = "  ";
    private static final char FIELD_SEPARATOR = '|';
    private static final String RECORD_BEGIN_MARKER = "[#|";
    private static final String RECORD_END_MARKER = "|#]";
    private static final String PAIR_SEPARATOR = ";";
    private static final String VALUE_SEPARATOR = "=";
    private static final String LABEL_CLASSNAME = "ClassName";
    private static final String LABEL_METHODNAME = "MethodName";
    private static final String LABEL_RECORDNUMBER = "RecordNumber";
    private final ExcludeFieldsSupport excludeFieldsSupport = new ExcludeFieldsSupport();
    private String recordBeginMarker = "[#|";
    private String recordEndMarker = "|#]";
    private char recordFieldSeparator = (char)124;
    private boolean multiline = true;

    public UniformLogFormatter(HandlerId handlerId) {
        super(handlerId);
        UniformLogFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
        UniformLogFormatter.configure(this, FormatterConfigurationHelper.forHandlerId(handlerId));
    }

    public UniformLogFormatter() {
        UniformLogFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
    }

    private static void configure(UniformLogFormatter formatter, FormatterConfigurationHelper helper) {
        formatter.setExcludeFields(helper.getString(UniformFormatterProperty.EXCLUDED_FIELDS, formatter.excludeFieldsSupport.toString()));
        formatter.setMultiline(helper.getBoolean(UniformFormatterProperty.MULTILINE, formatter.multiline));
        formatter.setRecordFieldSeparator(helper.getCharacter(UniformFormatterProperty.SEPARATOR_FIELD, Character.valueOf(formatter.recordFieldSeparator)));
        formatter.setRecordBeginMarker(helper.getString(UniformFormatterProperty.RECORD_MARKER_BEGIN, formatter.recordBeginMarker));
        formatter.setRecordEndMarker(helper.getString(UniformFormatterProperty.RECORD_MARKER_END, formatter.recordEndMarker));
    }

    @Override
    public String formatRecord(LogRecord record) {
        return this.formatGlassFishLogRecord(MSG_RESOLVER.resolve(record));
    }

    public void setRecordBeginMarker(String recordBeginMarker) {
        this.recordBeginMarker = recordBeginMarker == null ? RECORD_BEGIN_MARKER : recordBeginMarker;
    }

    public void setRecordEndMarker(String recordEndMarker) {
        this.recordEndMarker = recordEndMarker == null ? RECORD_END_MARKER : recordEndMarker;
    }

    public void setRecordFieldSeparator(Character recordFieldSeparator) {
        this.recordFieldSeparator = (char)(recordFieldSeparator == null ? 124 : (int)recordFieldSeparator.charValue());
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public void setExcludeFields(String excludeFields) {
        this.excludeFieldsSupport.setExcludedFields(excludeFields);
    }

    private String formatGlassFishLogRecord(GlassFishLogRecord record) {
        try {
            String message = this.getPrintedMessage(record);
            if (message == null) {
                return "";
            }
            String timestamp = this.getTimestampFormatter().format(record.getTime());
            Level logLevel = record.getLevel();
            StringBuilder output = new StringBuilder(512).append(this.recordBeginMarker);
            this.appendTimestamp(output, timestamp);
            this.appendLogLevel(output, logLevel);
            this.appendProductId(output);
            this.appendLoggerName(output, record.getLoggerName());
            this.appendDetails(output, record);
            if (this.multiline) {
                output.append(System.lineSeparator());
                output.append(MULTILINE_INDENTATION);
            }
            output.append(message);
            output.append(this.recordEndMarker);
            output.append(System.lineSeparator()).append(System.lineSeparator());
            return output.toString();
        }
        catch (Exception e) {
            new ErrorManager().error("Error in formatting Logrecord", e, 5);
            return record.getMessage();
        }
    }

    private void appendTimestamp(StringBuilder output, String timestamp) {
        output.append(timestamp);
        output.append(this.recordFieldSeparator);
    }

    private void appendLogLevel(StringBuilder output, Level logLevel) {
        output.append(logLevel.getName());
        output.append(this.recordFieldSeparator);
    }

    private void appendProductId(StringBuilder output) {
        String productId = LoggingSystemEnvironment.getProductId();
        if (productId != null) {
            output.append(productId);
        }
        output.append(this.recordFieldSeparator);
    }

    private void appendLoggerName(StringBuilder output, String loggerName) {
        if (loggerName != null) {
            output.append(loggerName);
        }
        output.append(this.recordFieldSeparator);
    }

    private void appendDetails(StringBuilder output, GlassFishLogRecord record) {
        if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.TID)) {
            output.append("_ThreadID").append(VALUE_SEPARATOR).append(record.getThreadID()).append(PAIR_SEPARATOR);
            output.append("_ThreadName").append(VALUE_SEPARATOR).append(record.getThreadName()).append(PAIR_SEPARATOR);
        }
        Level level = record.getLevel();
        if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.LEVEL_VALUE)) {
            output.append("_LevelValue").append(VALUE_SEPARATOR).append(level.intValue()).append(PAIR_SEPARATOR);
        }
        if (record.getMessageKey() != null) {
            output.append("_MessageID").append(VALUE_SEPARATOR).append(record.getMessageKey()).append(PAIR_SEPARATOR);
        }
        if (this.isPrintSource()) {
            String sourceMethodName;
            String sourceClassName = record.getSourceClassName();
            if (sourceClassName != null) {
                output.append(LABEL_CLASSNAME).append(VALUE_SEPARATOR).append(sourceClassName).append(PAIR_SEPARATOR);
            }
            if ((sourceMethodName = record.getSourceMethodName()) != null) {
                output.append(LABEL_METHODNAME).append(VALUE_SEPARATOR).append(sourceMethodName).append(PAIR_SEPARATOR);
            }
        }
        if (this.isPrintSequenceNumber()) {
            long recNumber = record.getSequenceNumber();
            output.append(LABEL_RECORDNUMBER).append(VALUE_SEPARATOR).append(recNumber).append(PAIR_SEPARATOR);
        }
        output.append(this.recordFieldSeparator);
    }

    public static enum UniformFormatterProperty implements LogProperty
    {
        EXCLUDED_FIELDS("excludedFields"),
        MULTILINE("multiline"),
        SEPARATOR_FIELD("fieldSeparator"),
        RECORD_MARKER_BEGIN("recordMarker.begin"),
        RECORD_MARKER_END("recordMarker.end");

        private final String propertyName;

        private UniformFormatterProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

