/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.shared.common.error.StandardException;

public class SQLRef
extends DataType
implements RefDataValue {
    protected RowLocation value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLRef.class);

    @Override
    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (null != this.value) {
            n += this.value.estimateMemoryUsage();
        }
        return n;
    }

    @Override
    public String getString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor.isNull()) {
            this.setToNull();
        } else {
            this.value = (RowLocation)dataValueDescriptor.getObject();
        }
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public String getTypeName() {
        return "REF";
    }

    @Override
    public int getTypeFormatId() {
        return 82;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.value = (RowLocation)objectInput.readObject();
    }

    @Override
    public void restoreToNull() {
        this.value = null;
    }

    @Override
    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        return this.value.compare(n, ((SQLRef)dataValueDescriptor).value, bl, bl2);
    }

    @Override
    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        return this.value.compare(((SQLRef)dataValueDescriptor).value);
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        if (this.value == null) {
            return new SQLRef();
        }
        return new SQLRef((RowLocation)this.value.cloneValue(false));
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLRef();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) {
    }

    @Override
    public void setInto(PreparedStatement preparedStatement, int n) {
    }

    public SQLRef() {
    }

    public SQLRef(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    @Override
    public void setValue(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        return this.value.toString();
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }
}

