/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.runnablejar.commandline;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.runnablejar.commandline.Arguments;
import org.glassfish.runnablejar.commandline.UnknownPropertyException;

public class CommandLineParser {
    private static Logger logger = Logger.getLogger(CommandLineParser.class.getName());

    public Arguments parse(String[] commandLineArgs) {
        Arguments arguments = new Arguments();
        arguments.setDefaults();
        for (int i = 0; i < commandLineArgs.length; ++i) {
            String arg = commandLineArgs[i];
            if (arg.startsWith("-")) {
                int initialCharsToIgnore = arg.startsWith("--") ? 2 : 1;
                String[] keyValue = arg.substring(2).split("=", initialCharsToIgnore);
                try {
                    if (keyValue.length == 2) {
                        arguments.setOption(keyValue[0], keyValue[1]);
                        continue;
                    }
                    arguments.setOption(keyValue[0], null);
                }
                catch (UnknownPropertyException e) {
                    logger.log(Level.WARNING, e, () -> "Unknown argument " + arg);
                }
                continue;
            }
            if (this.isdeployable(arg)) {
                arguments.deployables.add(arg);
                continue;
            }
            arguments.commands.add(arg);
        }
        return arguments;
    }

    private boolean isdeployable(String arg) {
        File file = new File(arg);
        return file.exists();
    }
}

