/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import jakarta.websocket.Decoder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.tyrus.core.ComponentProvider;
import org.glassfish.tyrus.core.DefaultComponentProvider;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ServiceFinder;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;

public class ComponentProviderService {
    private final Map<Session, Map<Class<?>, Object>> sessionToObject;
    private final List<ComponentProvider> providers;

    public static ComponentProviderService create() {
        ArrayList<ComponentProvider> foundProviders = new ArrayList<ComponentProvider>();
        ServiceFinder<ComponentProvider> finder = ServiceFinder.find(ComponentProvider.class);
        for (ComponentProvider componentProvider : finder) {
            foundProviders.add(componentProvider);
        }
        foundProviders.add(new DefaultComponentProvider());
        return new ComponentProviderService(Collections.unmodifiableList(foundProviders));
    }

    public static ComponentProviderService createClient() {
        return new ComponentProviderService(Collections.unmodifiableList(Arrays.asList(new DefaultComponentProvider())));
    }

    private ComponentProviderService(List<ComponentProvider> providers) {
        this.providers = providers;
        this.sessionToObject = new ConcurrentHashMap();
    }

    public ComponentProviderService(ComponentProviderService componentProviderService) {
        this.providers = componentProviderService.providers;
        this.sessionToObject = componentProviderService.sessionToObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Object getInstance(Class<T> c, Session session, ErrorCollector collector) {
        Object loaded;
        block8: {
            loaded = null;
            Map<Class<?>, Object> classObjectMap = this.sessionToObject.get(session);
            try {
                if (classObjectMap != null) {
                    Map<Class<?>, Object> map = classObjectMap;
                    synchronized (map) {
                        if (classObjectMap.containsKey(c)) {
                            loaded = classObjectMap.get(c);
                        } else {
                            loaded = this.getEndpointInstance(c);
                            this.sessionToObject.get(session).put(c, loaded);
                        }
                        break block8;
                    }
                }
                loaded = this.getEndpointInstance(c);
                HashMap<Class<T>, Object> hashMap = new HashMap<Class<T>, Object>();
                hashMap.put(c, loaded);
                this.sessionToObject.put(session, hashMap);
            }
            catch (Exception e) {
                collector.addException((Exception)new DeploymentException(LocalizationMessages.COMPONENT_PROVIDER_THREW_EXCEPTION(c.getName()), (Throwable)e));
            }
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Object getCoderInstance(Class<T> c, Session session, EndpointConfig endpointConfig, ErrorCollector collector) {
        Object loaded;
        block16: {
            loaded = null;
            Map<Class<?>, Object> classObjectMap = this.sessionToObject.get(session);
            try {
                if (classObjectMap != null) {
                    Map<Class<?>, Object> map = classObjectMap;
                    synchronized (map) {
                        if (classObjectMap.containsKey(c)) {
                            loaded = classObjectMap.get(c);
                        } else {
                            loaded = this.getInstance(c);
                            if (loaded != null) {
                                if (loaded instanceof Encoder) {
                                    ((Encoder)loaded).init(endpointConfig);
                                } else if (loaded instanceof Decoder) {
                                    ((Decoder)loaded).init(endpointConfig);
                                }
                                this.sessionToObject.get(session).put(c, loaded);
                            }
                        }
                        break block16;
                    }
                }
                loaded = this.getInstance(c);
                if (loaded != null) {
                    if (loaded instanceof Encoder) {
                        ((Encoder)loaded).init(endpointConfig);
                    } else if (loaded instanceof Decoder) {
                        ((Decoder)loaded).init(endpointConfig);
                    }
                    HashMap<Class<T>, Object> hashMap = new HashMap<Class<T>, Object>();
                    hashMap.put(c, loaded);
                    this.sessionToObject.put(session, hashMap);
                }
            }
            catch (InstantiationException e) {
                collector.addException((Exception)new DeploymentException(LocalizationMessages.COMPONENT_PROVIDER_THREW_EXCEPTION(c.getName()), (Throwable)e));
            }
        }
        return loaded;
    }

    public Method getInvocableMethod(Method method) {
        for (ComponentProvider componentProvider : this.providers) {
            if (!componentProvider.isApplicable(method.getDeclaringClass())) continue;
            return componentProvider.getInvocableMethod(method);
        }
        return method;
    }

    private <T> Object getInstance(Class<T> clazz) throws InstantiationException {
        for (ComponentProvider componentProvider : this.providers) {
            Object t;
            if (!componentProvider.isApplicable(clazz) || (t = componentProvider.create(clazz)) == null) continue;
            return t;
        }
        throw new InstantiationException(LocalizationMessages.COMPONENT_PROVIDER_NOT_FOUND(clazz.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session session) {
        Map<Class<?>, Object> classObjectMap = this.sessionToObject.get(session);
        if (classObjectMap != null) {
            Map<Class<?>, Object> map = classObjectMap;
            synchronized (map) {
                for (Object o : classObjectMap.values()) {
                    if (o instanceof Encoder) {
                        ((Encoder)o).destroy();
                    } else if (o instanceof Decoder) {
                        ((Decoder)o).destroy();
                    }
                    for (ComponentProvider componentProvider : this.providers) {
                        if (componentProvider.destroy(o)) break;
                    }
                }
            }
        }
        this.sessionToObject.remove(session);
    }

    public <T> Object getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        return this.getInstance(endpointClass);
    }
}

