/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.tools.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.pfl.basic.tools.argparser.ArgParser;
import org.glassfish.pfl.basic.tools.argparser.DefaultValue;
import org.glassfish.pfl.basic.tools.argparser.Help;
import org.glassfish.pfl.basic.tools.file.ActionFactory;
import org.glassfish.pfl.basic.tools.file.Block;
import org.glassfish.pfl.basic.tools.file.BlockParser;
import org.glassfish.pfl.basic.tools.file.FileWrapper;
import org.glassfish.pfl.basic.tools.file.Recognizer;
import org.glassfish.pfl.basic.tools.file.Scanner;

public class WorkspaceRename {
    private static final String[] SUBSTITUTE_SUFFIXES = new String[]{"c", "h", "java", "sjava", "idl", "htm", "html", "xml", "dtd", "tdesc", "policy", "secure", "vthought", "jmk", "ksh", "sh", "classlist", "config", "properties", "prp", "set", "settings", "data", "txt", "text", "javaref", "idlref"};
    private static final String[] SUBSTITUTE_NAMES = new String[]{"Makefile.corba", "Makefile.example", "ExampleMakefile", "Makefile", "manifest", "README", "README.SUN", "COPYING", "COPYRIGHT", "ChangeLog"};
    private static final String[] COPY_SUFFIXES = new String[]{"sxc", "sxi", "sxw", "odp", "odt", "gif", "png", "jar", "zip", "jpg", "pom", "pdf", "doc", "mif", "fm", "book", "zargo", "zuml", "cvsignore", "hgignore", "list", "old", "orig", "rej", "hgtags", "xsl", "bat", "css", "icns", "bin", "ico", "init", "ss", "pp", "el", "mail", "lisp", "sch", "tst", "xcf", "war"};
    private static final String[] IGNORE_SUFFIXES = new String[]{"swm", "swn", "swo", "swp", "class", "o", "gz"};
    private static final String[] IGNORE_NAMES = new String[]{"NORENAME", "errorfile", "sed_pattern_file.version", "package-list", ".hgtags"};
    private static final String[] IGNORE_DIRS = new String[]{".hg", ".snprj", ".cvs", "SCCS", "obj", "obj_g", "Codemgr_wsdata", "deleted_files", "build", "rename", "freezepoint", "test-output", "webrev", "javadoc", "felix-cache", "vpproject"};
    private final int verbose;
    private final boolean dryrun;
    private final File source;
    private final File destination;
    private final String version;
    private final boolean copyonly;
    private final boolean expandtabs;
    private final List<ArgParser.StringPair> patterns;
    private final List<String> noActionFileNames = new ArrayList<String>();

    public static void main(String[] strs) {
        new WorkspaceRename(strs).run();
    }

    private void trace(String msg) {
        System.out.println(msg);
    }

    private FileWrapper makeTargetFileWrapper(FileWrapper arg) {
        String rootName = this.source.getAbsolutePath();
        String sourceName = arg.getAbsoluteName();
        if (this.verbose > 1) {
            this.trace("makeTargetFileWrapper: rootName = " + rootName);
            this.trace("makeTargetFileWrapper: sourceName = " + sourceName);
        }
        if (sourceName.startsWith(rootName)) {
            String targetName = sourceName.substring(rootName.length());
            for (ArgParser.StringPair astr : this.patterns) {
                String key = (String)astr.first();
                String replacement = (String)astr.second();
                if (sourceName.indexOf(key) < 0) continue;
                targetName = targetName.replace(key, replacement);
            }
            File result = new File(this.destination, targetName);
            File resultDir = result.getParentFile();
            resultDir.mkdirs();
            FileWrapper fwres = new FileWrapper(result);
            if (this.verbose > 1) {
                this.trace("makeTargetFileWrapper: arg = " + arg);
                this.trace("makeTargetFileWrapper: fwres = " + fwres);
            }
            return fwres;
        }
        throw new RuntimeException("makeTargetFileWrapper: arg file " + sourceName + " does not start with root name " + rootName);
    }

    public WorkspaceRename(String[] strs) {
        ArgParser ap = new ArgParser(Arguments.class);
        Arguments args = ap.parse(strs, Arguments.class);
        this.version = args.version();
        this.source = args.source();
        this.destination = args.destination();
        this.verbose = args.verbose();
        this.dryrun = args.dryrun();
        this.copyonly = args.copyonly();
        this.patterns = new ArrayList<ArgParser.StringPair>();
        for (ArgParser.StringPair sp : args.patterns()) {
            String key = (String)sp.first();
            String value = ((String)sp.second()).replace("VERSION", this.version);
            ArgParser.StringPair newSp = new ArgParser.StringPair(key, value);
            this.patterns.add(newSp);
            String slashKey = key.replace(".", "/");
            String slashValue = value.replace(".", "/");
            ArgParser.StringPair slashSp = new ArgParser.StringPair(slashKey, slashValue);
            this.patterns.add(slashSp);
        }
        this.expandtabs = args.expandtabs();
        if (this.verbose > 1) {
            this.trace("Main: args:\n" + args);
            this.trace("Main: patterns: " + this.patterns);
        }
    }

    private void run() {
        try {
            final byte[] copyBuffer = new byte[262144];
            Scanner.Action copyAction = new Scanner.Action(){

                public String toString() {
                    return "copyAction";
                }

                public boolean evaluate(FileWrapper fw) {
                    try {
                        FileWrapper target = WorkspaceRename.this.makeTargetFileWrapper(fw);
                        if (target.isYoungerThan(fw)) {
                            if (WorkspaceRename.this.verbose > 0) {
                                WorkspaceRename.this.trace("copyAction: copying " + fw + " to " + target);
                            }
                            fw.copyTo(target, copyBuffer);
                        } else if (WorkspaceRename.this.verbose > 1) {
                            WorkspaceRename.this.trace("copyAction: NOT copying " + fw + " to " + target);
                        }
                        return true;
                    }
                    catch (IOException exc) {
                        System.out.println("Exception while processing file " + fw + ": " + exc);
                        exc.printStackTrace();
                        return false;
                    }
                }
            };
            Scanner.Action renameAction = new Scanner.Action(){

                public String toString() {
                    return "renameAction";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean evaluate(FileWrapper fw) {
                    try (FileWrapper target = WorkspaceRename.this.makeTargetFileWrapper(fw);){
                        if (target.isYoungerThan(fw)) {
                            if (WorkspaceRename.this.verbose > 0) {
                                WorkspaceRename.this.trace("renameAction: renaming " + fw + " to " + target);
                            }
                            Block sourceBlock = BlockParser.getBlock(fw);
                            Block targetBlock = sourceBlock.substitute(WorkspaceRename.this.patterns);
                            if (WorkspaceRename.this.expandtabs) {
                                targetBlock = targetBlock.expandTabs();
                            }
                            target.delete();
                            target.open(FileWrapper.OpenMode.WRITE);
                            targetBlock.write(target);
                        } else if (WorkspaceRename.this.verbose > 1) {
                            WorkspaceRename.this.trace("renameAction: NOT renaming " + fw + " to " + target);
                        }
                        boolean sourceBlock = true;
                        return sourceBlock;
                    }
                }
            };
            ActionFactory af = new ActionFactory(this.verbose, this.dryrun);
            Recognizer recognizer = af.getRecognizerAction();
            recognizer.setDefaultAction(new Scanner.Action(){

                public String toString() {
                    return "WorkspaceRename default action";
                }

                public boolean evaluate(FileWrapper fw) {
                    if (!fw.getName().startsWith("tmp")) {
                        WorkspaceRename.this.noActionFileNames.add(fw.getAbsoluteName());
                    }
                    return true;
                }
            });
            Scanner.Action skipAction = af.getSkipAction();
            Scanner.Action action = this.copyonly ? copyAction : renameAction;
            for (String str : SUBSTITUTE_SUFFIXES) {
                recognizer.addKnownSuffix(str, action);
            }
            for (String str : SUBSTITUTE_NAMES) {
                recognizer.addKnownName(str, action);
            }
            recognizer.setShellScriptAction(action);
            for (String str : COPY_SUFFIXES) {
                recognizer.addKnownSuffix(str, copyAction);
            }
            for (String str : IGNORE_SUFFIXES) {
                recognizer.addKnownSuffix(str, skipAction);
            }
            for (String str : IGNORE_NAMES) {
                recognizer.addKnownName(str, skipAction);
            }
            if (this.verbose > 1) {
                this.trace("Main: contents of recognizer:");
                recognizer.dump();
            }
            Scanner scanner = new Scanner(this.verbose, this.source);
            for (String str : IGNORE_DIRS) {
                scanner.addDirectoryToSkip(str);
            }
            scanner.scan(recognizer);
            int rc = this.noActionFileNames.size();
            if (rc > 0) {
                System.out.println("Rename FAILED: no action defined for files:");
                for (String str : this.noActionFileNames) {
                    System.out.println("\t" + str);
                }
                System.exit(rc);
            }
        }
        catch (IOException exc) {
            System.out.println("Exception while processing: " + exc);
            exc.printStackTrace();
        }
    }

    private static interface Arguments {
        @Help(value="Set to >0 to get information about actions taken for every file.  Larger values give more detail.")
        @DefaultValue(value="0")
        public int verbose();

        @Help(value="Set to true to avoid modifying any files")
        @DefaultValue(value="false")
        public boolean dryrun();

        @Help(value="Source directory for rename")
        @DefaultValue(value="")
        public File source();

        @Help(value="Destination directory for rename")
        @DefaultValue(value="")
        public File destination();

        @Help(value="The renamed package")
        @DefaultValue(value="ee")
        public String version();

        @Help(value="If true, copy all files without renaming anything")
        @DefaultValue(value="false")
        public boolean copyonly();

        @Help(value="If true, expand all tabs into spaces on files that are renamed (all text file)")
        @DefaultValue(value="true")
        public boolean expandtabs();

        @Help(value="List of patterns given as <source java package name>:<renamed java package name>. Also handes the /-separated version of the pattern.  If the string VERSION occurs in the renamed java package name, it will be replaced with the value of the version() argument.")
        @DefaultValue(value="")
        public List<ArgParser.StringPair> patterns();
    }
}

