/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.time.Instant;
import org.eclipse.persistence.descriptors.JavaTimeLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class InstantLockingPolicy
extends JavaTimeLockingPolicy<Instant> {
    public InstantLockingPolicy() {
    }

    public InstantLockingPolicy(DatabaseField field) {
        super(field);
    }

    @Override
    int compareJavaTimeLockValues(Instant value1, Instant value2) {
        return value1.compareTo(value2);
    }

    @Override
    Class<Instant> getDefaultJavaTimeLockFieldType() {
        return ClassConstants.TIME_INSTANT;
    }

    @Override
    Instant getBaseJavaTimeValue() {
        return Instant.MIN;
    }

    @Override
    Instant getInitialJavaTimeWriteValue(AbstractSession session) {
        switch (this.getTimeSource()) {
            case Local: {
                return Instant.now();
            }
            case Server: {
                AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
                Platform platform = session.getDatasourcePlatform();
                while (readSession.isUnitOfWork()) {
                    readSession = readSession.getParent().getSessionForClass(this.getDescriptor().getJavaClass());
                }
                return platform.convertObject(session.executeQuery(platform.getTimestampQuery()), ClassConstants.TIME_INSTANT);
            }
        }
        return null;
    }

    @Override
    Instant getNewJavaTimeLockValue(ModifyQuery query) {
        return this.getInitialJavaTimeWriteValue(query.getSession());
    }

    @Override
    Instant getJavaTimeValueToPutInCache(AbstractRecord row, AbstractSession session) {
        if (this.isStoredInCache()) {
            return session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), ClassConstants.TIME_INSTANT);
        }
        return null;
    }

    @Override
    Instant getWriteJavaTimeLockValue(Object domainObject, Object primaryKey, AbstractSession session) {
        Instant writeLockFieldValue = null;
        if (this.isStoredInCache()) {
            writeLockFieldValue = (Instant)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor());
        } else {
            Object lockValue = this.lockValueFromObject(domainObject);
            if (lockValue != null) {
                if (lockValue instanceof Instant) {
                    writeLockFieldValue = (Instant)this.lockValueFromObject(domainObject);
                } else {
                    throw OptimisticLockException.needToMapJavaSqlTimestampWhenStoredInObject();
                }
            }
        }
        return writeLockFieldValue;
    }

    @Override
    boolean isNewerJavaTimeVersion(Instant current, Object domainObject, Object primaryKey, AbstractSession session) {
        Instant writeLockFieldValue = this.isStoredInCache() ? (Instant)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (Instant)this.lockValueFromObject(domainObject);
        return this.isNewerJavaTimeVersion(current, writeLockFieldValue);
    }

    @Override
    boolean isNewerJavaTimeVersion(AbstractRecord row, Object domainObject, Object primaryKey, AbstractSession session) {
        Instant newWriteLockFieldValue = session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), ClassConstants.TIME_INSTANT);
        Instant writeLockFieldValue = this.isStoredInCache() ? (Instant)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (Instant)this.lockValueFromObject(domainObject);
        return this.isNewerJavaTimeVersion(newWriteLockFieldValue, writeLockFieldValue);
    }

    @Override
    boolean isNewerJavaTimeVersion(Instant first, Instant second) {
        if (first == null) {
            return false;
        }
        if (second == null) {
            return true;
        }
        return first.isAfter(second);
    }

    @Override
    public int getVersionDifference(Object currentValue, Object domainObject, Object primaryKeys, AbstractSession session) {
        Instant newWriteLockFieldValue = (Instant)currentValue;
        if (newWriteLockFieldValue == null) {
            return 0;
        }
        Instant writeLockFieldValue = this.isStoredInCache() ? (Instant)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKeys, domainObject.getClass(), this.getDescriptor()) : (Instant)this.lockValueFromObject(domainObject);
        if (newWriteLockFieldValue.equals(writeLockFieldValue)) {
            return 0;
        }
        if (writeLockFieldValue != null && !newWriteLockFieldValue.isAfter(writeLockFieldValue)) {
            return -1;
        }
        return 1;
    }
}

