/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.xr.StoredProcedureQueryHandler;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class StoredFunctionQueryHandler
extends StoredProcedureQueryHandler {
    @Override
    public boolean isStoredFunctionQueryHandler() {
        return true;
    }

    @Override
    protected StoredProcedureCall createCall() {
        return new StoredFunctionCall();
    }

    @Override
    protected void setSingleResult(XRServiceAdapter xrService, StoredProcedureCall spCall, QName resultType) {
        if (this.isCursorType(xrService, resultType)) {
            spCall.useUnnamedCursorOutputAsResultSet();
        } else {
            StoredFunctionCall sfCall = (StoredFunctionCall)spCall;
            Class<?> clz = Util.SCHEMA_2_CLASS.get(resultType);
            if (clz != null) {
                sfCall.setResult("", clz);
            } else {
                sfCall.setResult("", CoreClassConstants.OBJECT);
            }
            DatabasePlatform platform = xrService.getORSession().getPlatform();
            if (platform == null) {
                platform = new DatabasePlatform();
            }
            ((DatabaseField)sfCall.getParameters().get(0)).setSqlType(platform.getJDBCType(clz));
        }
    }
}

