/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.fileupload;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class PartHeaders
implements Serializable {
    private static final long serialVersionUID = -4455695752627032559L;
    private final Map<String, List<String>> headerMap = new LinkedHashMap<String, List<String>>();
    private Set<String> headerNames = null;

    PartHeaders() {
    }

    public String getHeader(String name) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        List<String> headerValueList = this.headerMap.get(nameLower);
        if (null == headerValueList) {
            return null;
        }
        return headerValueList.get(0);
    }

    public synchronized Collection<String> getHeaderNames() {
        if (null == this.headerNames) {
            this.headerNames = Collections.unmodifiableSet(this.headerMap.keySet());
        }
        return this.headerNames;
    }

    public List<String> getHeaders(String name) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        List<String> headerValueList = this.headerMap.get(nameLower);
        if (null == headerValueList) {
            return Collections.emptyList();
        }
        return headerValueList;
    }

    public synchronized void addHeader(String name, String value) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        List<String> headerValueList = this.headerMap.get(nameLower);
        if (null == headerValueList) {
            headerValueList = new ArrayList<String>();
            this.headerMap.put(nameLower, headerValueList);
        }
        headerValueList.add(value);
    }
}

