/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import com.sun.jsftemplating.resource.ResourceBundleManager;
import com.sun.jsftemplating.util.Util;
import jakarta.faces.context.FacesContext;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageUtil {
    private static final MessageUtil _instance = new MessageUtil();

    private MessageUtil() {
    }

    public static MessageUtil getInstance() {
        return _instance;
    }

    public String getMessage(String baseName, String key) {
        return this.getMessage(baseName, key, null);
    }

    public String getMessage(String baseName, String key, Object[] args) {
        return this.getMessage(null, baseName, key, args);
    }

    public String getMessage(Locale locale, String baseName, String key, Object[] args) {
        ResourceBundle bundle;
        if (key == null) {
            return null;
        }
        if (baseName == null) {
            throw new RuntimeException("'baseName' is null for key '" + key + "'!");
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (locale == null) {
            locale = Util.getLocale(ctx);
        }
        if ((bundle = ResourceBundleManager.getInstance(ctx).getBundle(baseName, locale)) == null) {
            return key;
        }
        String message = null;
        try {
            message = bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (message == null) {
            return key;
        }
        return MessageUtil.getFormattedMessage(message, args);
    }

    public static String getFormattedMessage(String message, Object[] args) {
        if (message == null || args == null || args.length == 0) {
            return message;
        }
        String result = null;
        MessageFormat mf = new MessageFormat(message);
        result = mf.format(args);
        return result != null ? result : message;
    }
}

