/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.internal.ide.undo.AbstractResourceDescription;
import org.eclipse.ui.internal.ide.undo.IFileContentDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class FileDescription
extends AbstractResourceDescription {
    String name;
    URI location;
    String charset;
    private IFileContentDescription fileContentDescription;

    public FileDescription(IFile file) {
        super((IResource)file);
        this.name = file.getName();
        try {
            this.charset = file.getCharset(false);
        }
        catch (CoreException coreException) {}
        if (file.isLinked()) {
            this.location = file.getLocationURI();
        }
    }

    public FileDescription(IFile file, URI linkLocation, IFileContentDescription fileContentDescription) {
        super((IResource)file);
        this.name = file.getName();
        this.location = linkLocation;
        this.charset = null;
        this.fileContentDescription = fileContentDescription;
    }

    @Override
    public void recordStateFromHistory(IResource resource, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((resource.getType() == 1 ? 1 : 0) != 0);
        if (this.location != null) {
            return;
        }
        IFileState[] states = ((IFile)resource).getHistory(monitor);
        if (states.length > 0) {
            final IFileState state = this.getMatchingFileState(states);
            this.fileContentDescription = new IFileContentDescription(){

                @Override
                public boolean exists() {
                    return state.exists();
                }

                @Override
                public InputStream getContents() throws CoreException {
                    return state.getContents();
                }

                @Override
                public String getCharset() throws CoreException {
                    return state.getCharset();
                }
            };
        }
    }

    @Override
    public IResource createResourceHandle() {
        IWorkspaceRoot workspaceRoot = this.parent.getWorkspace().getRoot();
        IPath fullPath = this.parent.getFullPath().append(this.name);
        return workspaceRoot.getFile(fullPath);
    }

    @Override
    public void createExistentResourceFromHandle(IResource resource, IProgressMonitor mon) throws CoreException {
        Assert.isLegal((boolean)(resource instanceof IFile));
        if (resource.exists()) {
            return;
        }
        IFile fileHandle = (IFile)resource;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)200);
        subMonitor.setTaskName(UndoMessages.FileDescription_NewFileProgress);
        try {
            if (this.location != null) {
                fileHandle.createLink(this.location, 16, (IProgressMonitor)subMonitor.split(200));
            } else {
                InputStream contents = new ByteArrayInputStream(UndoMessages.FileDescription_ContentsCouldNotBeRestored.getBytes());
                if (this.fileContentDescription != null && this.fileContentDescription.exists()) {
                    contents = this.fileContentDescription.getContents();
                }
                fileHandle.create(contents, false, (IProgressMonitor)subMonitor.split(100));
                fileHandle.setCharset(this.charset, (IProgressMonitor)subMonitor.split(100));
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
    }

    @Override
    public boolean isValid() {
        if (this.location != null) {
            return super.isValid();
        }
        return super.isValid() && this.fileContentDescription != null && this.fileContentDescription.exists();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private IFileState getMatchingFileState(IFileState[] states) {
        IFileState[] iFileStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            IFileState state = iFileStateArray[n2];
            if (this.localTimeStamp == state.getModificationTime()) {
                return state;
            }
            ++n2;
        }
        return states[0];
    }

    @Override
    protected void restoreResourceAttributes(IResource resource) throws CoreException {
        super.restoreResourceAttributes(resource);
        Assert.isLegal((boolean)(resource instanceof IFile));
        IFile file = (IFile)resource;
        if (this.charset != null) {
            file.setCharset(this.charset, null);
        }
    }
}

