/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.launchconfiguration.ui.tabs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.util.StandardWidgetToolkit;
import org.eclipse.efm.execution.core.IWorkflowConfigurationConstants;
import org.eclipse.efm.execution.core.SymbexPreferenceUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class SymbexRuntimeTab
extends AbstractLaunchConfigurationTab
implements IWorkflowConfigurationConstants {
    public static final String FIRST_EDIT = "editedByDiversityAvmTab";
    protected Text fArgumentField;
    protected Button fArgumentVariablesButton;
    private Button fWorkingDirectoryWorkspaceButton;
    private Button fWorkingDirectoryFileSystemButton;
    private Button fWorkingDirectoryVariablesButton;
    private Button fWorkingDirectoryUseDefaultButton = null;
    private Text fWorkingDirectoryText = null;
    private Button fAvmLocationWorkspaceButton;
    private Button fAvmLocationFileSystemButton;
    private Button fAvmLocationVariablesButton;
    private Button fAvmLocationUseDefaultButton = null;
    private Button fAvmLocationUseOtherButton = null;
    private Text fAvmLocationDefaultText = null;
    private Combo fSelectedAvmLocationCombo = null;
    private boolean fUsedDefaultAvmLocation = true;
    private ArrayList<String> fAvmLocations = null;
    String fGlobalPrefLocation = null;
    private ILaunchConfiguration fLaunchConfiguration;
    protected boolean fInitializing = false;
    private boolean userEdited = false;
    private WidgetListener fListener = new WidgetListener();
    IWidgetToolkit widgetToolkit = new StandardWidgetToolkit();

    public SymbexRuntimeTab() {
        this.fGlobalPrefLocation = SymbexPreferenceUtil.strDiversityAvmExecLocation();
        this.fAvmLocations = new ArrayList();
        this.setHelpContextId("org.eclipse.efm.modeling.doc.helpcontents.sew_launch_SymbexRuntime_tab");
    }

    public String getName() {
        return "&Symbex-Runtime";
    }

    private void handleArgumentVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    private void handleWorkingDirectoryFileBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select a working directory for the launch configuration:");
        String currentWorkingDir = this.getWorkingDirectoryText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.fWorkingDirectoryText.setText(selectedDirectory);
        }
    }

    private void handleWorkingDirectoryWorkspaceBrowseButtonSelected() {
        IContainer currentContainer = this.getContainer();
        if (currentContainer == null) {
            currentContainer = ResourcesPlugin.getWorkspace().getRoot();
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), currentContainer, false, "Select a working directory for the launch configuration:");
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.makeRelative().toString();
            this.setWorkingDirectoryText("${workspace_loc:" + containerName + "}");
        }
    }

    protected IContainer getContainer() {
        String path = this.getWorkingDirectoryText();
        if (path.length() > 0) {
            IResource res = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.startsWith("${workspace_loc:")) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    path = manager.performStringSubstitution(path, false);
                    IPath uriPath = new Path(path).makeAbsolute();
                    IContainer[] containers = root.findContainersForLocationURI(URIUtil.toURI((IPath)uriPath));
                    if (containers.length > 0) {
                        res = containers[0];
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                res = root.findMember(path);
            }
            if (res instanceof IContainer) {
                return (IContainer)res;
            }
        }
        return null;
    }

    private void handleWorkingDirectoryUseDefaultButtonSelected() {
        if (this.fWorkingDirectoryUseDefaultButton.getSelection()) {
            this.setWorkingDirectoryDefaultText();
            this.setEnabledWorkingDirectoryComponent(false);
        } else {
            this.setEnabledWorkingDirectoryComponent(true);
        }
    }

    private void setEnabledWorkingDirectoryComponent(boolean enabledFlag) {
        this.fWorkingDirectoryText.setEnabled(enabledFlag);
        this.fWorkingDirectoryWorkspaceButton.setEnabled(enabledFlag);
        this.fWorkingDirectoryVariablesButton.setEnabled(enabledFlag);
        this.fWorkingDirectoryFileSystemButton.setEnabled(enabledFlag);
    }

    private void handleWorkingDirectoryVariablesButtonSelected() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        String variableText = dialog.getVariableExpression();
        if (variableText != null) {
            this.fWorkingDirectoryText.insert(variableText);
        }
    }

    protected void initializeWorkingDirectoryComponent(String dir) {
        if (dir == null) {
            this.setWorkingDirectoryDefaultText();
        } else {
            this.setWorkingDirectoryText(dir);
        }
        this.fWorkingDirectoryUseDefaultButton.setSelection(dir == null);
        this.setEnabledWorkingDirectoryComponent(dir != null);
    }

    protected void setWorkingDirectoryDefaultText() {
        this.setWorkingDirectoryText(System.getProperty("user.dir"));
    }

    protected void setWorkingDirectoryText(String dir) {
        if (dir != null) {
            this.fWorkingDirectoryText.setText(dir);
        }
    }

    void updateWorkingDirectoryDefaultText() {
        if (this.fWorkingDirectoryUseDefaultButton.getSelection()) {
            this.setWorkingDirectoryDefaultText();
        }
    }

    protected final String getWorkingDirectoryText() {
        return this.fWorkingDirectoryText.getText().trim();
    }

    protected boolean isValidWorkingDirectory() {
        this.setErrorMessage(null);
        this.setMessage(null);
        String workingDirPath = this.getWorkingDirectoryText();
        if (workingDirPath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(workingDirPath);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        } else if (workingDirPath.length() > 0) {
            IContainer container = this.getContainer();
            if (container == null) {
                File dir = new File(workingDirPath);
                if (dir.isDirectory()) {
                    return true;
                }
                this.setErrorMessage("Working directory does not exist");
                return false;
            }
        } else if (workingDirPath.length() == 0) {
            this.setErrorMessage("Working directory not specified");
            return false;
        }
        return true;
    }

    String[] getAvmLocationItems() {
        return this.fAvmLocations.toArray(new String[this.fAvmLocations.size()]);
    }

    String[] addAvmLocationItems(String addLocation) {
        Path pathDefault = new Path(addLocation);
        ArrayList<String> avmLocations = new ArrayList<String>();
        avmLocations.add(addLocation);
        for (String location : this.fAvmLocations) {
            Path pathOther = new Path(location);
            if (pathDefault.equals((Object)pathOther)) continue;
            avmLocations.add(pathOther.toOSString());
        }
        this.fAvmLocations.clear();
        this.fAvmLocations.addAll(avmLocations);
        return this.fAvmLocations.toArray(new String[this.fAvmLocations.size()]);
    }

    String[] resetOtheAvmLocationItems(List<?> locations) {
        Path pathDefault = new Path(this.fGlobalPrefLocation);
        this.fAvmLocations.clear();
        for (Object location : locations) {
            Path pathOther = new Path(location.toString());
            if (pathDefault.equals((Object)pathOther)) continue;
            this.fAvmLocations.add(pathOther.toOSString());
        }
        return this.fAvmLocations.toArray(new String[this.fAvmLocations.size()]);
    }

    private void handleAvmLocationSelectionChange() {
        this.addAvmLocationItems(this.fSelectedAvmLocationCombo.getText());
        try {
            this.performApplyAvmLocation(this.fLaunchConfiguration.getWorkingCopy());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void handleAvmLocationBrowseButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        String location = this.fSelectedAvmLocationCombo.getText();
        if (location == null || location.isEmpty()) {
            location = this.fGlobalPrefLocation;
        }
        fileDialog.setFileName(location);
        fileDialog.setFilterExtensions(new String[]{"*.exe", "*.*"});
        String text = fileDialog.open();
        if (text != null) {
            this.fSelectedAvmLocationCombo.setItems(this.addAvmLocationItems(text));
            if (!this.fAvmLocations.isEmpty()) {
                this.fSelectedAvmLocationCombo.select(0);
            }
        }
    }

    private void handleAvmLocationWorkspaceBrowseButtonSelected() {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Select a &Symbex tool relative working location:");
        if (dialog.open() == 0) {
            Object[] results = dialog.getResult();
            if (results == null || results.length < 1) {
                return;
            }
            if (results[0] instanceof IPath) {
                IPath path = (IPath)results[0];
                String containerName = path.makeRelative().toString();
                this.setAvmLocationText("${workspace_loc:" + containerName + "}");
            }
        }
    }

    private void handleAvmLocationUseOtherButtonSelected(boolean isEnabled) {
        this.fSelectedAvmLocationCombo.setEnabled(isEnabled);
        this.fAvmLocationWorkspaceButton.setEnabled(isEnabled);
        this.fAvmLocationVariablesButton.setEnabled(isEnabled);
        this.fAvmLocationFileSystemButton.setEnabled(isEnabled);
        if (isEnabled) {
            this.updateLaunchConfigurationDialog();
        }
    }

    private void handleAvmLocationVariablesButtonSelected() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        String variableText = dialog.getVariableExpression();
        if (variableText != null) {
            this.fSelectedAvmLocationCombo.setText(String.valueOf(this.fSelectedAvmLocationCombo.getText()) + variableText);
        }
    }

    protected void setAvmLocationDefaultText() {
        this.fAvmLocationDefaultText.setText(this.fGlobalPrefLocation);
        this.handleAvmLocationUseOtherButtonSelected(false);
    }

    protected final String getAvmLocationText() {
        if (this.fUsedDefaultAvmLocation) {
            return this.fGlobalPrefLocation;
        }
        return this.fSelectedAvmLocationCombo.getText().trim();
    }

    protected final void setAvmLocationText(String location) {
        if (location != null) {
            Path pathOther;
            Path pathDefault = new Path(this.fSelectedAvmLocationCombo.getText());
            if (pathDefault.equals((Object)(pathOther = new Path(location)))) {
                return;
            }
            this.fSelectedAvmLocationCombo.setItems(this.addAvmLocationItems(location));
            if (!this.fAvmLocations.isEmpty()) {
                this.fSelectedAvmLocationCombo.select(0);
            }
            this.handleAvmLocationUseOtherButtonSelected(true);
        }
    }

    protected final void setAvmLocationItems(List<?> locations) {
        if (locations != null) {
            this.fSelectedAvmLocationCombo.setItems(this.resetOtheAvmLocationItems(locations));
            if (!this.fAvmLocations.isEmpty()) {
                this.fSelectedAvmLocationCombo.select(0);
            }
            this.handleAvmLocationUseOtherButtonSelected(true);
        }
    }

    public boolean isValidAvmLocation() {
        this.setErrorMessage(null);
        this.setMessage(null);
        String avmLocationPath = this.getAvmLocationText();
        if (avmLocationPath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(avmLocationPath);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        } else {
            if (avmLocationPath.length() > 0) {
                File location = new File(avmLocationPath);
                if (location.isFile()) {
                    return true;
                }
                this.setErrorMessage("Symbex executable location does not exist");
                return false;
            }
            if (avmLocationPath.length() == 0) {
                this.setErrorMessage("ymbex executable location not specified");
                return false;
            }
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createAvmLocationComponent(mainComposite);
        this.createWorkingDirectoryComponent(mainComposite);
        this.createArgumentComponent(mainComposite);
        this.setControl((Control)mainComposite);
    }

    protected void createArgumentComponent(Composite parent) {
        Group group = this.widgetToolkit.createGroup(parent, "&Arguments:", 1, 1, 1808);
        this.fArgumentField = new Text((Composite)group, 2626);
        this.fArgumentField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 4 && (event.stateMask & SWT.MODIFIER_MASK) != 0) {
                    event.doit = true;
                }
            }
        });
        GridData gridData = new GridData(1808);
        gridData.widthHint = 200;
        gridData.heightHint = 30;
        this.fArgumentField.setLayoutData((Object)gridData);
        this.fArgumentField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fArgumentField, group.getText());
        Composite buttonComposite = this.widgetToolkit.createComposite((Composite)group, parent.getFont(), 1, 1, 128, 0, 0);
        this.fArgumentVariablesButton = this.createPushButton(buttonComposite, "Variable&s...", null);
        this.fArgumentVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fArgumentVariablesButton, this.fArgumentVariablesButton.getText());
        Label instruction = new Label((Composite)group, 0);
        instruction.setText("Note: Enclose an argument containing spaces using double-quotes (\").");
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        instruction.setLayoutData((Object)gridData);
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuffer stripped = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    protected void createWorkingDirectoryComponent(Composite parent) {
        Group group = this.widgetToolkit.createGroup(parent, "&Working directory:", 2, 1, 768);
        Font font = parent.getFont();
        Composite comp = this.widgetToolkit.createComposite((Composite)group, font, 2, 2, 1808, 0, 0);
        this.fWorkingDirectoryUseDefaultButton = this.createCheckButton(comp, "Defa&ult:");
        this.fWorkingDirectoryUseDefaultButton.addSelectionListener((SelectionListener)this.fListener);
        this.fWorkingDirectoryText = this.widgetToolkit.createSingleText(comp, 1);
        this.fWorkingDirectoryText.addModifyListener((ModifyListener)this.fListener);
        Composite buttonComp = this.widgetToolkit.createComposite(comp, font, 3, 2, 128);
        GridLayout ld = (GridLayout)buttonComp.getLayout();
        ld.marginHeight = 1;
        ld.marginWidth = 0;
        this.fWorkingDirectoryWorkspaceButton = this.createPushButton(buttonComp, "W&orkspace...", null);
        this.fWorkingDirectoryWorkspaceButton.addSelectionListener((SelectionListener)this.fListener);
        this.fWorkingDirectoryFileSystemButton = this.createPushButton(buttonComp, "&File System...", null);
        this.fWorkingDirectoryFileSystemButton.addSelectionListener((SelectionListener)this.fListener);
        this.fWorkingDirectoryVariablesButton = this.createPushButton(buttonComp, "Variabl&es...", null);
        this.fWorkingDirectoryVariablesButton.addSelectionListener((SelectionListener)this.fListener);
    }

    protected void createAvmLocationComponent(Composite parent) {
        Group group = this.widgetToolkit.createGroup(parent, "&Symbex Executable Location:", 2, 1, 768);
        Font font = parent.getFont();
        Composite comp = this.widgetToolkit.createComposite((Composite)group, font, 2, 2, 1808, 0, 0);
        this.fAvmLocationUseDefaultButton = this.widgetToolkit.createRadioButton(comp, "Defa&ult:");
        this.fAvmLocationUseDefaultButton.addSelectionListener((SelectionListener)this.fListener);
        this.fAvmLocationDefaultText = this.widgetToolkit.createSingleText(comp, 1);
        this.fAvmLocationDefaultText.addModifyListener((ModifyListener)this.fListener);
        this.fAvmLocationDefaultText.setEnabled(false);
        this.fAvmLocationUseOtherButton = this.widgetToolkit.createRadioButton(comp, "Ot&her:");
        this.fAvmLocationUseOtherButton.addSelectionListener((SelectionListener)this.fListener);
        this.fSelectedAvmLocationCombo = this.widgetToolkit.createCombo(comp, 4, 1, this.getAvmLocationItems());
        this.fSelectedAvmLocationCombo.addSelectionListener((SelectionListener)this.fListener);
        this.fSelectedAvmLocationCombo.addModifyListener((ModifyListener)this.fListener);
        Composite buttonComp = this.widgetToolkit.createComposite(comp, font, 3, 2, 128);
        GridLayout ld = (GridLayout)buttonComp.getLayout();
        ld.marginHeight = 1;
        ld.marginWidth = 0;
        this.fAvmLocationWorkspaceButton = this.createPushButton(buttonComp, "W&orkspace...", null);
        this.fAvmLocationWorkspaceButton.addSelectionListener((SelectionListener)this.fListener);
        this.fAvmLocationFileSystemButton = this.createPushButton(buttonComp, "&File System...", null);
        this.fAvmLocationFileSystemButton.addSelectionListener((SelectionListener)this.fListener);
        this.fAvmLocationVariablesButton = this.createPushButton(buttonComp, "Variabl&es...", null);
        this.fAvmLocationVariablesButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        this.fLaunchConfiguration = configuration;
        this.initializeFromArgument(configuration);
        this.initializeFromWorkingDirectory(configuration);
        this.initializeFromAvmLocation(configuration);
        this.fInitializing = false;
        this.setDirty(false);
    }

    public void initializeFromArgument(ILaunchConfiguration configuration) {
        String arguments = "";
        try {
            arguments = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TOOL_ARGUMENTS", "");
        }
        catch (CoreException e) {
            this.setErrorMessage("Exception occurred reading << Argument >> configuration:" + e.getStatus().getMessage());
        }
        this.fArgumentField.setText(arguments);
    }

    public void initializeFromWorkingDirectory(ILaunchConfiguration configuration) {
        try {
            this.initializeWorkingDirectoryComponent(configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_WORKING_DIRECTORY", null));
        }
        catch (CoreException e) {
            this.setErrorMessage("Exception occurred reading << Working Directory >> configuration:" + e.getStatus().getMessage());
        }
    }

    public void initializeFromAvmLocation(ILaunchConfiguration configuration) {
        List<String> avmLocation = null;
        try {
            avmLocation = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_LAUNCH_AVM_LOCATION_HISTORY", null);
        }
        catch (CoreException coreException) {}
        if (avmLocation == null) {
            try {
                String strLocation = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_LAUNCH_AVM_LOCATION_HISTORY", null);
                if (strLocation != null) {
                    avmLocation = Arrays.asList(strLocation);
                    this.setDirty(true);
                }
            }
            catch (CoreException coreException) {}
        }
        this.setAvmLocationItems(avmLocation);
        try {
            this.fUsedDefaultAvmLocation = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_LAUNCH_AVM_LOCATION_USED_DEFAULT", true);
        }
        catch (CoreException coreException) {}
        if (this.fUsedDefaultAvmLocation) {
            this.setAvmLocationDefaultText();
            try {
                String location = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_LAUNCH_AVM_LOCATION", null);
                if (!this.fGlobalPrefLocation.equals(location)) {
                    this.setWarningMessage("Global Preference < Symbex Executable Location > has changed !");
                }
            }
            catch (CoreException coreException) {}
        } else {
            this.fAvmLocationDefaultText.setText(this.fGlobalPrefLocation);
        }
        this.fAvmLocationUseDefaultButton.setSelection(this.fUsedDefaultAvmLocation);
        this.fAvmLocationUseOtherButton.setSelection(!this.fUsedDefaultAvmLocation);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.performApplyArgument(configuration);
        this.performApplyWorkingDirectory(configuration);
        this.performApplyAvmLocation(configuration);
        if (this.userEdited) {
            configuration.setAttribute(FIRST_EDIT, null);
        }
    }

    public void performApplyArgument(ILaunchConfigurationWorkingCopy configuration) {
        String arguments = this.fArgumentField.getText().trim();
        if (arguments.length() == 0) {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TOOL_ARGUMENTS", null);
        } else {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TOOL_ARGUMENTS", arguments);
        }
    }

    public void performApplyWorkingDirectory(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fWorkingDirectoryUseDefaultButton.getSelection()) {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_WORKING_DIRECTORY", null);
        } else {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_WORKING_DIRECTORY", this.getWorkingDirectoryText());
        }
    }

    public void performApplyAvmLocation(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_LAUNCH_AVM_LOCATION_HISTORY", this.fAvmLocations);
        String location = null;
        this.fUsedDefaultAvmLocation = this.fAvmLocationUseDefaultButton.getSelection();
        if (this.fUsedDefaultAvmLocation) {
            location = this.fGlobalPrefLocation;
            if (!location.equals(this.fGlobalPrefLocation)) {
                location = this.fGlobalPrefLocation;
                this.fAvmLocationDefaultText.setText(location);
            }
        } else {
            location = this.fSelectedAvmLocationCombo.getText().trim();
        }
        if (location == null || location.isEmpty()) {
            location = this.fGlobalPrefLocation;
        }
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_LAUNCH_AVM_LOCATION_USED_DEFAULT", this.fUsedDefaultAvmLocation);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_LAUNCH_AVM_LOCATION", location);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.setDefaultsArgument(configuration);
        this.setDefaultsWorkingDirectory(configuration);
        this.setDefaultsAvmLocation(configuration);
    }

    public void setDefaultsArgument(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_TOOL_ARGUMENTS", null);
    }

    public void setDefaultsWorkingDirectory(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_WORKING_DIRECTORY", null);
    }

    public void setDefaultsAvmLocation(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_LAUNCH_AVM_LOCATION_USED_DEFAULT", true);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_LAUNCH_AVM_LOCATION", this.fGlobalPrefLocation);
    }

    public void updateLaunchConfigurationDialog() {
        this.validateTab();
        super.updateLaunchConfigurationDialog();
    }

    public void validateTab() {
        this.isValidWorkingDirectory();
        this.isValidAvmLocation();
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!SymbexRuntimeTab.this.fInitializing) {
                SymbexRuntimeTab.this.setDirty(true);
                SymbexRuntimeTab.this.userEdited = true;
                SymbexRuntimeTab.this.updateLaunchConfigurationDialog();
            }
            SymbexRuntimeTab.this.scheduleUpdateJob();
        }

        public void widgetSelected(SelectionEvent e) {
            SymbexRuntimeTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == SymbexRuntimeTab.this.fArgumentVariablesButton) {
                SymbexRuntimeTab.this.handleArgumentVariablesButtonSelected(SymbexRuntimeTab.this.fArgumentField);
            } else if (source == SymbexRuntimeTab.this.fWorkingDirectoryWorkspaceButton) {
                SymbexRuntimeTab.this.handleWorkingDirectoryWorkspaceBrowseButtonSelected();
            } else if (source == SymbexRuntimeTab.this.fWorkingDirectoryFileSystemButton) {
                SymbexRuntimeTab.this.handleWorkingDirectoryFileBrowseButtonSelected();
            } else if (source == SymbexRuntimeTab.this.fWorkingDirectoryVariablesButton) {
                SymbexRuntimeTab.this.handleWorkingDirectoryVariablesButtonSelected();
            } else if (source == SymbexRuntimeTab.this.fWorkingDirectoryUseDefaultButton) {
                SymbexRuntimeTab.this.handleWorkingDirectoryUseDefaultButtonSelected();
            } else if (e.getSource() == SymbexRuntimeTab.this.fSelectedAvmLocationCombo) {
                SymbexRuntimeTab.this.handleAvmLocationSelectionChange();
            } else if (source == SymbexRuntimeTab.this.fAvmLocationWorkspaceButton) {
                SymbexRuntimeTab.this.handleAvmLocationWorkspaceBrowseButtonSelected();
            } else if (source == SymbexRuntimeTab.this.fAvmLocationFileSystemButton) {
                SymbexRuntimeTab.this.handleAvmLocationBrowseButtonSelected();
            } else if (source == SymbexRuntimeTab.this.fAvmLocationVariablesButton) {
                SymbexRuntimeTab.this.handleAvmLocationVariablesButtonSelected();
            } else if (source == SymbexRuntimeTab.this.fAvmLocationUseDefaultButton) {
                SymbexRuntimeTab.this.fUsedDefaultAvmLocation = SymbexRuntimeTab.this.fAvmLocationUseDefaultButton.getSelection();
                if (SymbexRuntimeTab.this.fUsedDefaultAvmLocation) {
                    SymbexRuntimeTab.this.setAvmLocationDefaultText();
                }
            } else if (source == SymbexRuntimeTab.this.fAvmLocationUseOtherButton) {
                if (SymbexRuntimeTab.this.fAvmLocationUseOtherButton.getSelection()) {
                    SymbexRuntimeTab.this.handleAvmLocationUseOtherButtonSelected(true);
                    SymbexRuntimeTab.this.fUsedDefaultAvmLocation = false;
                } else {
                    SymbexRuntimeTab.this.fUsedDefaultAvmLocation = true;
                }
            }
        }
    }
}

