/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.INTERNAL, since="5.0")
public class NestedClassTestDescriptor
extends ClassTestDescriptor {
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();

    public NestedClassTestDescriptor(UniqueId uniqueId, Class<?> testClass) {
        super(uniqueId, Class::getSimpleName, testClass);
    }

    @Override
    public final Set<TestTag> getTags() {
        Set<TestTag> localTags = super.getTags();
        this.getParent().ifPresent(parentDescriptor -> localTags.addAll(parentDescriptor.getTags()));
        return localTags;
    }

    @Override
    protected Object instantiateTestClass(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ExtensionContext extensionContext) {
        Optional<ExtensionRegistry> childExtensionRegistryForOuterInstance = Optional.empty();
        Object outerInstance = parentExecutionContext.getTestInstanceProvider().getTestInstance(childExtensionRegistryForOuterInstance);
        Constructor constructor = ReflectionUtils.getDeclaredConstructor(this.getTestClass());
        return executableInvoker.invoke(constructor, outerInstance, extensionContext, registry);
    }
}

