/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.interpolation.IdentityInterpolator;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.Utils;
import fr.inria.zvtm.engine.VCursor;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VImage;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Vector;
import net.claribole.zgrviewer.BaseEventHandler;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LElem;
import net.claribole.zgrviewer.ZGRViewer;

public class ZgrvEvtHdlr
extends BaseEventHandler
implements ViewListener {
    protected ZGRViewer application;
    Glyph startG;
    Glyph endG;
    LEdge edge;

    protected ZgrvEvtHdlr(ZGRViewer app, GraphicsManager gm) {
        this.application = app;
        this.grMngr = gm;
    }

    public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            return;
        }
        this.lastJPX = jpx;
        this.lastJPY = jpy;
        Glyph g = v.lastGlyphEntered();
        if (this.inZoomWindow) {
            if (this.grMngr.dmPortal.coordInsideBar(jpx, jpy)) {
                this.draggingZoomWindow = true;
            } else {
                this.draggingZoomWindowContent = true;
            }
        } else if (this.inMagWindow) {
            v.getVCursor().stickGlyph(this.grMngr.magWindow);
            this.draggingMagWindow = true;
        } else if (this.grMngr.tp.isBringAndGoMode() && g != null) {
            this.grMngr.startBringAndGo(g);
        } else if (this.grMngr.tp.isLinkSlidingMode()) {
            Point location = e.getComponent().getLocationOnScreen();
            this.relative = e.getPoint();
            this.LS_SX = v.getVCursor().getVSXCoordinate();
            this.LS_SY = v.getVCursor().getVSYCoordinate();
            this.grMngr.attemptLinkSliding(this.LS_SX, this.LS_SY, location.x, location.y);
        } else if (this.grMngr.tp.isEditMode()) {
            this.pressInEditMode(g, v.getVCursor(), this.grMngr.mainCamera, mod);
        } else {
            this.grMngr.rememberLocation(v.cams[0].getLocation());
            if (mod == 0 || mod == 1 || mod == 4 || mod == 5) {
                this.manualLeftButtonMove = true;
                this.lastJPX = jpx;
                this.lastJPY = jpy;
                v.getVCursor().setSensitivity(false);
                this.activeCam = this.grMngr.vsm.getActiveCamera();
            } else if (mod == 6) {
                this.zoomingInRegion = true;
                this.x1 = v.getVCursor().getVSXCoordinate();
                this.y1 = v.getVCursor().getVSYCoordinate();
                v.setDrawRect(true);
            }
        }
    }

    public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (ConfigManager.DYNASPOT && !this.toolPaletteIsActive && !v.getVCursor().getDynaPicker().isDynaSpotActivated()) {
            this.grMngr.activateDynaSpot(true, false);
        }
        if (this.grMngr.isBringingAndGoing) {
            this.grMngr.endBringAndGo(v.lastGlyphEntered());
        } else if (this.grMngr.isLinkSliding) {
            this.grMngr.endLinkSliding();
        }
        if (this.toolPaletteIsActive) {
            return;
        }
        this.draggingZoomWindow = false;
        this.draggingZoomWindowContent = false;
        if (this.editingSpline || this.movingEdgeLabelOrBox) {
            v.getVCursor().unstickLastGlyph();
            this.movingEdgeLabelOrBox = false;
            this.editingSpline = false;
        } else if (this.movingNode) {
            v.getVCursor().unstickLastGlyph();
            this.grMngr.geom.unstickAll();
            this.movingNode = false;
        }
        if (this.draggingMagWindow) {
            this.draggingMagWindow = false;
            v.getVCursor().unstickLastGlyph();
        }
        if (this.zoomingInRegion) {
            v.setDrawRect(false);
            this.x2 = v.getVCursor().getVSXCoordinate();
            this.y2 = v.getVCursor().getVSYCoordinate();
            if (Math.abs(this.x2 - this.x1) >= 4.0 && Math.abs(this.y2 - this.y1) >= 4.0) {
                this.grMngr.mainView.centerOnRegion(this.grMngr.vsm.getActiveCamera(), 300, this.x1, this.y1, this.x2, this.y2);
            }
            this.zoomingInRegion = false;
        } else if (this.manualLeftButtonMove) {
            this.grMngr.mainCamera.setXspeed(0.0);
            this.grMngr.mainCamera.setYspeed(0.0);
            this.grMngr.mainCamera.setZspeed(0.0);
            v.hideFirstOrderPanWidget();
            v.getVCursor().setSensitivity(true);
            if (this.autoZooming) {
                this.unzoom(v);
            }
            this.manualLeftButtonMove = false;
        }
    }

    public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            if (clickNumber == 2) {
                return;
            }
            if (v.lastGlyphEntered() != null) {
                this.grMngr.tp.selectMode((VImage)v.lastGlyphEntered());
            }
        } else if (mod == 4) {
            if (clickNumber == 2) {
                return;
            }
            if (this.grMngr.tp.isHighlightMode() && v.getGlyphsUnderCursorList().length > 0) {
                Glyph g = v.lastGlyphEntered();
                this.grMngr.highlightElement(g, v.cams[0], v.getVCursor(), true, 0, true, -1);
            }
        } else {
            if (this.grMngr.tp.isBringAndGoMode() || this.grMngr.tp.isLinkSlidingMode()) {
                return;
            }
            if (this.grMngr.tp.isFadingLensNavMode() || this.grMngr.tp.isProbingLensNavMode()) {
                if (clickNumber == 2) {
                    return;
                }
                this.lastJPX = jpx;
                this.lastJPY = jpy;
                this.lastVX = v.getVCursor().getVSXCoordinate();
                this.lastVY = v.getVCursor().getVSYCoordinate();
                if (this.grMngr.lensType != 0) {
                    this.grMngr.zoomInPhase2(this.lastVX, this.lastVY);
                } else {
                    if (this.cursorNearBorder) {
                        return;
                    }
                    this.grMngr.zoomInPhase1(jpx, jpy);
                }
            } else if (this.grMngr.tp.isDragMagNavMode()) {
                if (clickNumber == 2) {
                    return;
                }
                this.grMngr.triggerDM(jpx, jpy, this);
            } else {
                if (this.grMngr.tp.isEditMode()) {
                    return;
                }
                if (clickNumber == 2) {
                    this.click2(v, mod, jpx, jpy, clickNumber, e);
                } else {
                    Glyph g = v.lastGlyphEntered();
                    if (mod == 1) {
                        this.grMngr.highlightElement(g, v.cams[0], v.getVCursor(), true, 0, true, -1);
                    } else if (g != null && g != this.grMngr.boundingBox) {
                        this.grMngr.mainView.centerOnGlyph(g, v.cams[0], 300, true, ConfigManager.MAG_FACTOR);
                    }
                }
            }
        }
    }

    public void press2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (this.grMngr.tp.isEditMode()) {
            if (this.startG != null) {
                this.endG = v.lastGlyphEntered();
                this.edge = this.grMngr.addEdge(this.startG, this.endG, "test", true);
                this.endG = null;
                this.startG = null;
            } else {
                this.startG = v.lastGlyphEntered();
            }
        }
    }

    public void release2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            return;
        }
        if (clickNumber == 2) {
            return;
        }
        Glyph g = v.lastGlyphEntered();
        if (g != null && g != this.grMngr.boundingBox) {
            if (g.getOwner() != null) {
                this.getAndDisplayURL((LElem)g.getOwner(), g);
            }
        } else {
            this.attemptDisplayEdgeURL(v.getVCursor(), v.cams[0]);
        }
    }

    public void press3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (ConfigManager.DYNASPOT) {
            this.grMngr.activateDynaSpot(false, false);
        }
        if (this.toolPaletteIsActive) {
            return;
        }
        if (this.grMngr.tp.isFadingLensNavMode() || this.grMngr.tp.isProbingLensNavMode()) {
            this.lastJPX = jpx;
            this.lastJPY = jpy;
        } else {
            v.parent.setActiveLayer(1);
            this.application.displayMainPieMenu(true);
        }
    }

    public void release3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        if (ConfigManager.DYNASPOT) {
            this.grMngr.activateDynaSpot(true, false);
        }
        if (this.toolPaletteIsActive) {
            return;
        }
        Glyph g = v.getVCursor().getPicker().lastGlyphEntered();
        if (g != null && g.getType() == "mpmE") {
            this.application.pieMenuEvent(g);
        }
        if (this.application.mainPieMenu != null) {
            this.application.displayMainPieMenu(false);
        }
        if (this.application.subPieMenu != null) {
            this.application.displaySubMenu(null, false);
        }
        v.parent.setActiveLayer(0);
    }

    public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        if (this.toolPaletteIsActive) {
            return;
        }
        if (this.grMngr.tp.isFadingLensNavMode() || this.grMngr.tp.isProbingLensNavMode()) {
            if (clickNumber == 2) {
                return;
            }
            this.lastJPX = jpx;
            this.lastJPY = jpy;
            this.lastVX = v.getVCursor().getVSXCoordinate();
            this.lastVY = v.getVCursor().getVSYCoordinate();
            if (this.grMngr.lensType != 0) {
                this.grMngr.zoomOutPhase2();
            } else {
                if (this.cursorNearBorder) {
                    return;
                }
                this.grMngr.zoomOutPhase1(jpx, jpy, this.lastVX, this.lastVY);
            }
        }
    }

    public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
        this.lx = jpx;
        this.ly = jpy;
        if (jpx - 100 < 0) {
            this.lx = 100;
            this.cursorNearBorder = true;
        } else if (jpx + 100 > this.grMngr.panelWidth) {
            this.lx = this.grMngr.panelWidth - 100;
            this.cursorNearBorder = true;
        } else {
            this.cursorNearBorder = false;
        }
        if (jpy - 100 < 0) {
            this.ly = 100;
            this.cursorNearBorder = true;
        } else if (jpy + 100 > this.grMngr.panelHeight) {
            this.ly = this.grMngr.panelHeight - 100;
            this.cursorNearBorder = true;
        }
        if (this.grMngr.lensType != 0 && this.grMngr.lens != null) {
            this.grMngr.moveLens(this.lx, this.ly, e.getWhen());
        } else if (this.grMngr.tp.isEnabled()) {
            if (this.grMngr.tp.insidePaletteTriggerZone(jpx, jpy)) {
                if (!this.grMngr.tp.isShowing()) {
                    this.grMngr.tp.show();
                    this.toolPaletteIsActive = true;
                }
            } else if (this.grMngr.tp.isShowing()) {
                this.grMngr.tp.hide();
                this.toolPaletteIsActive = false;
            }
        }
        if (ConfigManager.DYNASPOT) {
            v.getVCursor().getDynaPicker().dynaPick(this.grMngr.mainCamera);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
        if (this.toolPaletteIsActive || this.grMngr.isBringingAndGoing) {
            return;
        }
        if (v.getVCursor().getDynaPicker().isDynaSpotActivated()) {
            this.grMngr.activateDynaSpot(false, false);
        }
        if (this.editingSpline) {
            this.grMngr.geom.updateEdgeSpline();
        } else {
            if (this.movingEdgeLabelOrBox || this.movingNode) {
                return;
            }
            if (this.grMngr.isLinkSliding) {
                this.grMngr.linkSlider(v.getVCursor().getVSXCoordinate(), v.getVCursor().getVSYCoordinate(), false);
            } else if (mod != 6 && buttonNumber == 1) {
                if (this.draggingZoomWindow) {
                    this.grMngr.dmPortal.move(jpx - this.lastJPX, jpy - this.lastJPY);
                    this.lastJPX = jpx;
                    this.lastJPY = jpy;
                    this.grMngr.vsm.repaint();
                } else if (this.draggingZoomWindowContent) {
                    this.tfactor = (this.grMngr.dmCamera.focal + this.grMngr.dmCamera.altitude) / this.grMngr.dmCamera.focal;
                    Camera camera = this.grMngr.dmCamera;
                    synchronized (camera) {
                        this.grMngr.dmCamera.move(Math.round(this.tfactor * (double)(this.lastJPX - jpx)), Math.round(this.tfactor * (double)(jpy - this.lastJPY)));
                        this.lastJPX = jpx;
                        this.lastJPY = jpy;
                        this.grMngr.updateMagWindow();
                    }
                } else if (this.draggingMagWindow) {
                    this.grMngr.updateZoomWindow();
                } else if (this.manualLeftButtonMove) {
                    if (!v.isShowingFirstOrderPanWidget()) {
                        v.showFirstOrderPanWidget(this.lastJPX, this.lastJPY);
                    }
                    if (mod == 1 || mod == 5) {
                        this.grMngr.mainCamera.setXspeed(0.0);
                        this.grMngr.mainCamera.setYspeed(0.0);
                        this.grMngr.mainCamera.setZspeed((float)(this.lastJPY - jpy) * 0.02f);
                    } else {
                        this.tfactor = (this.activeCam.focal + Math.abs(this.activeCam.altitude)) / this.activeCam.focal;
                        this.jpxD = jpx - this.lastJPX;
                        this.jpyD = this.lastJPY - jpy;
                        this.grMngr.mainCamera.setXspeed(this.activeCam.altitude > 0.0 ? (double)this.jpxD * (this.tfactor / 50.0) : (double)this.jpxD / (this.tfactor * 50.0));
                        this.grMngr.mainCamera.setYspeed(this.activeCam.altitude > 0.0 ? (double)this.jpyD * (this.tfactor / 50.0) : (double)this.jpyD / (this.tfactor * 50.0));
                        this.grMngr.mainCamera.setZspeed(0.0);
                        if (ZGRViewer.cfgMngr.isSDZoomEnabled()) {
                            this.dragValue = Math.sqrt(this.jpxD * this.jpxD + this.jpyD * this.jpyD);
                            if (!this.autoZooming) {
                                if (this.dragValue > ZGRViewer.cfgMngr.SD_ZOOM_THRESHOLD) {
                                    this.autoZooming = true;
                                    Animation a = this.grMngr.vsm.getAnimationManager().getAnimationFactory().createCameraAltAnim(300, v.cams[0], new Float(ZGRViewer.cfgMngr.autoZoomFactor * (v.cams[0].getAltitude() + v.cams[0].getFocal())).floatValue(), true, IdentityInterpolator.getInstance(), null);
                                    this.grMngr.vsm.getAnimationManager().startAnimation(a, false);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.grMngr.lensType != 0 && this.grMngr.lens != null) {
            this.grMngr.moveLens(jpx, jpy, e.getWhen());
        }
    }

    public void mouseWheelMoved(ViewPanel v, short wheelDirection, int jpx, int jpy, MouseWheelEvent e) {
        if (this.grMngr.lensType != 0 && this.grMngr.lens != null) {
            if (wheelDirection == 1) {
                this.grMngr.magnifyFocus(1.0, this.grMngr.lensType, this.grMngr.mainCamera);
            } else {
                this.grMngr.magnifyFocus(-1.0, this.grMngr.lensType, this.grMngr.mainCamera);
            }
        } else if (this.grMngr.tp.isHighlightMode() && v.getGlyphsUnderCursorList().length > 0) {
            Glyph g = v.lastGlyphEntered();
            int dir = -1;
            if (e.isShiftDown()) {
                dir = 1;
            }
            if (e.isControlDown()) {
                dir = 2;
            }
            if (e.isShiftDown() && e.isControlDown()) {
                dir = 0;
            }
            this.grMngr.highlightElement(g, null, null, true, wheelDirection == 1 ? -1 : 1, false, dir);
        } else if (this.inZoomWindow) {
            this.tfactor = (this.grMngr.dmCamera.focal + Math.abs(this.grMngr.dmCamera.altitude)) / this.grMngr.dmCamera.focal;
            if (wheelDirection == 1) {
                this.grMngr.dmCamera.altitudeOffset(-this.tfactor * 21.0);
            } else {
                this.grMngr.dmCamera.altitudeOffset(this.tfactor * 22.0);
            }
            this.grMngr.updateMagWindow();
            this.grMngr.vsm.repaint();
        } else {
            this.tfactor = (this.grMngr.mainCamera.focal + Math.abs(this.grMngr.mainCamera.altitude)) / this.grMngr.mainCamera.focal;
            this.mvx = v.getVCursor().getVSXCoordinate();
            this.mvy = v.getVCursor().getVSYCoordinate();
            if (wheelDirection == 1) {
                this.grMngr.mainCamera.vx -= (double)Math.round((this.mvx - this.grMngr.mainCamera.vx) * 21.0 / this.grMngr.mainCamera.focal);
                this.grMngr.mainCamera.vy -= (double)Math.round((this.mvy - this.grMngr.mainCamera.vy) * 21.0 / this.grMngr.mainCamera.focal);
                this.grMngr.mainCamera.altitudeOffset(this.tfactor * 21.0);
                this.grMngr.cameraMoved(null, null, 0.0);
            } else {
                if (this.grMngr.mainCamera.getAltitude() > -90.0) {
                    this.grMngr.mainCamera.vx += (double)Math.round((this.mvx - this.grMngr.mainCamera.vx) * 22.0 / this.grMngr.mainCamera.focal);
                    this.grMngr.mainCamera.vy += (double)Math.round((this.mvy - this.grMngr.mainCamera.vy) * 22.0 / this.grMngr.mainCamera.focal);
                }
                this.grMngr.mainCamera.altitudeOffset(-this.tfactor * 22.0);
                this.grMngr.cameraMoved(null, null, 0.0);
            }
        }
    }

    public void enterGlyph(Glyph g) {
        this.grMngr.mainView.setStatusBarText(" ");
        if (g == this.grMngr.magWindow) {
            this.inMagWindow = true;
            return;
        }
        if (g == this.grMngr.boundingBox) {
            return;
        }
        if (this.grMngr.vsm.getActiveView().getActiveLayer() == 1) {
            g.highlight(true, null);
            VirtualSpace vs = this.grMngr.vsm.getVirtualSpace("menuSpace");
            vs.onTop(g);
            int i = Utils.indexOfGlyph(this.application.mainPieMenu.getItems(), g);
            if (i != -1) {
                vs.onTop(this.application.mainPieMenu.getLabels()[i]);
            } else {
                i = Utils.indexOfGlyph(this.application.subPieMenu.getItems(), g);
                if (i != -1) {
                    vs.onTop(this.application.subPieMenu.getLabels()[i]);
                }
            }
        } else if (g.getType() != null) {
            if (g.getType().equals("sge")) {
                this.grMngr.mainView.setCursorIcon(13);
            } else if (g.getType().equals("tpb")) {
                g.highlight(true, null);
            }
        } else if (this.grMngr.tp.isHighlightMode()) {
            this.grMngr.highlightElement(g, null, null, true, 0, false, -1);
        } else {
            g.highlight(true, null);
        }
    }

    public void exitGlyph(Glyph g) {
        if (g == this.grMngr.magWindow) {
            this.inMagWindow = false;
            return;
        }
        if (g == this.grMngr.boundingBox) {
            return;
        }
        if (this.grMngr.vsm.getActiveView().getActiveLayer() == 1) {
            g.highlight(false, null);
            if (this.application.mainPieMenu != null && g == this.application.mainPieMenu.getBoundary()) {
                Glyph lge = this.grMngr.vsm.getActiveView().mouse.getPicker().lastGlyphEntered();
                if (lge != null && lge.getType() == "mpmS") {
                    this.application.mainPieMenu.setSensitivity(false);
                    this.application.displaySubMenu(lge, true);
                }
            } else if (this.application.subPieMenu != null && g == this.application.subPieMenu.getBoundary()) {
                this.application.displaySubMenu(null, false);
                this.application.mainPieMenu.setSensitivity(true);
            }
        } else if (g.getType() != null) {
            if (g.getType().equals("sge")) {
                this.grMngr.mainView.setCursorIcon(-1);
            } else if (g.getType().equals("tpb")) {
                g.highlight(false, null);
            }
        } else if (this.application.grMngr.tp.isHighlightMode()) {
            this.grMngr.unhighlightAll();
        } else {
            g.highlight(false, null);
        }
    }

    public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        if (code == 33) {
            this.grMngr.getHigherView();
        } else if (code == 34) {
            this.grMngr.getLowerView();
        } else if (code == 36) {
            this.grMngr.getGlobalView();
        } else if (code == 38) {
            this.grMngr.translateView((short)1);
        } else if (code == 40) {
            this.grMngr.translateView((short)0);
        } else if (code == 37) {
            this.grMngr.translateView((short)3);
        } else if (code == 39) {
            this.grMngr.translateView((short)2);
        } else if (code == 76 || code == 32) {
            Glyph g = v.lastGlyphEntered();
            if (g != null) {
                if (g.getOwner() != null) {
                    this.getAndDisplayURL((LElem)g.getOwner(), g);
                }
            } else {
                this.attemptDisplayEdgeURL(v.getVCursor(), v.cams[0]);
            }
        }
    }

    public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void viewActivated(View v) {
    }

    public void viewDeactivated(View v) {
    }

    public void viewIconified(View v) {
    }

    public void viewDeiconified(View v) {
    }

    public void viewClosing(View v) {
        this.application.exit();
    }

    public void attemptDisplayEdgeURL(VCursor mouse, Camera cam) {
        Glyph g;
        Vector<Glyph> otherGlyphs = mouse.getPicker().getIntersectingGlyphs(cam);
        if (otherGlyphs != null && otherGlyphs.size() > 0 && (g = otherGlyphs.firstElement()).getOwner() != null) {
            this.getAndDisplayURL((LElem)g.getOwner(), g);
        }
    }

    public void getAndDisplayURL(LElem noa, Glyph g) {
        String url = noa.getURL(g);
        if (url != null && url.length() > 0) {
            this.application.displayURLinBrowser(url);
        }
    }
}

