/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.common;

import org.eclipse.efm.execution.core.util.PrettyPrintWriter;
import org.eclipse.efm.execution.core.workflow.common.TraceElement;
import org.eclipse.efm.execution.core.workflow.common.TraceElementKind;
import org.eclipse.efm.execution.core.workflow.common.impl.TraceElementImpl;

public class TraceElementCustomImpl
extends TraceElementImpl {
    private static final String UNSELECTION_MARKER = "//!#";

    public TraceElementCustomImpl(boolean selected, TraceElementKind nature, Object value) {
        this.selected = selected;
        this.nature = nature;
        this.value = value;
    }

    public TraceElementCustomImpl(TraceElementKind nature, Object value) {
        this(true, nature, value);
    }

    public TraceElementCustomImpl(TraceElement model) {
        this(model.isSelected(), model.getNature(), model.getValue());
    }

    public static TraceElementCustomImpl create(String element) {
        return TraceElementCustomImpl.create(element, TraceElementKind.UNDEFINED);
    }

    public static TraceElementCustomImpl create(String element, TraceElementKind defaultNature) {
        boolean selected = true;
        TraceElementKind nature = TraceElementKind.UNDEFINED;
        while (element.startsWith(UNSELECTION_MARKER)) {
            selected = false;
            element = element.substring(UNSELECTION_MARKER.length()).trim();
        }
        String value = element;
        if (element.startsWith("//")) {
            nature = TraceElementKind.COMMENT;
            value = value.substring(2).trim();
        } else {
            int pos = element.indexOf(61);
            if (pos > 0) {
                String kind = element.substring(0, pos).trim();
                nature = TraceElementKind.get(kind);
                if (nature != null) {
                    value = element.substring(pos + 1).trim();
                } else {
                    nature = defaultNature;
                }
            } else {
                nature = defaultNature;
                value = element.trim();
            }
        }
        return new TraceElementCustomImpl(selected, nature, value);
    }

    @Override
    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        Object value = this.getValue();
        if (!this.isSelected()) {
            strBuffer.append(UNSELECTION_MARKER);
        }
        switch (this.getNature()) {
            case UNDEFINED: {
                String[] stringArray = value.toString().split(" *\\R");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    strBuffer.append("// ").append(line).append('\n');
                    ++n2;
                }
                break;
            }
            case COMMENT: {
                strBuffer.append("//").append(value.toString()).append('\n');
                break;
            }
            case RAW_ATTRIBUTE: {
                strBuffer.append(value.toString()).append('\n');
                break;
            }
            default: {
                strBuffer.append(this.getNature().getLiteral()).append(" = ");
                if (value instanceof String) {
                    String str = value.toString();
                    if (!(str.startsWith("\"") || str.startsWith("'") || str.startsWith("[") && !str.startsWith("[*]"))) {
                        strBuffer.append("\"").append(str).append("\"");
                    } else {
                        strBuffer.append(str);
                    }
                } else if (value != null) {
                    strBuffer.append(value.toString());
                } else {
                    strBuffer.append("'<null>'");
                }
                strBuffer.append('\n');
            }
        }
        return strBuffer.toString();
    }

    public void toWriter(PrettyPrintWriter writer) {
        Object value = this.getValue();
        writer.appendTab(this.isSelected() ? "" : UNSELECTION_MARKER);
        switch (this.getNature()) {
            case UNDEFINED: {
                writer.commentLine(value);
                break;
            }
            case COMMENT: {
                writer.append("//").appendEol(value.toString());
                break;
            }
            case RAW_ATTRIBUTE: {
                writer.appendEol(value.toString());
                break;
            }
            default: {
                writer.append(this.getNature().getLiteral()).append(" = ");
                if (value instanceof String) {
                    String str = value.toString();
                    if (!(str.startsWith("\"") || str.startsWith("'") || str.startsWith("[") && !str.startsWith("[*]"))) {
                        writer.append("\"").append(str).appendEol("\"");
                        break;
                    }
                    writer.appendEol(str);
                    break;
                }
                if (value != null) {
                    writer.appendEol(value.toString());
                    break;
                }
                writer.appendEol("'<null>'");
            }
        }
    }
}

