/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.RectangularShape;
import fr.inria.zvtm.glyphs.projection.RProjectedCoordsP;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class VSwingComponent<T>
extends ClosedShape
implements RectangularShape {
    public double vw;
    public double vh;
    public double ar;
    int[] xcoords = new int[4];
    int[] ycoords = new int[4];
    JComponent sc;
    public AffineTransform at;
    public RProjectedCoordsP[] pc;
    public boolean zoomSensitive = true;
    public double scaleFactor = 1.0;
    public double trueCoef = 1.0;

    public VSwingComponent(JComponent c) {
        this(0.0, 0.0, 0, c, 1.0, 0.0, 1.0f);
    }

    public VSwingComponent(double x, double y, int z, JComponent c) {
        this(x, y, z, c, 1.0, 0.0, 1.0f);
    }

    public VSwingComponent(double x, double y, int z, JComponent c, double scale) {
        this(x, y, z, c, scale, 0.0, 1.0f);
    }

    public VSwingComponent(double x, double y, int z, JComponent c, double scale, float alpha) {
        this(x, y, z, c, scale, 0.0, 1.0f);
    }

    public VSwingComponent(double x, double y, int z, JComponent c, double scale, double or, float alpha) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.sc = c;
        this.sc.setDoubleBuffered(false);
        this.vw = (double)this.sc.getWidth() * scale;
        this.vh = (double)this.sc.getHeight() * scale;
        this.ar = this.vw == 0.0 && this.vh == 0.0 ? 1.0 : this.vw / this.vh;
        this.computeSize();
        this.orient = or;
        this.scaleFactor = scale;
        this.setTranslucencyValue(alpha);
        this.setDrawBorder(false);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new RProjectedCoordsP[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new RProjectedCoordsP();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                RProjectedCoordsP[] ta = this.pc;
                this.pc = new RProjectedCoordsP[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new RProjectedCoordsP();
            } else {
                System.err.println("VSwingComponent:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new RProjectedCoordsP[1];
            this.pc[0] = new RProjectedCoordsP();
        } else {
            System.err.println("VSwingComponent:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public void orientTo(double angle) {
        this.orient = angle;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = Math.sqrt(this.vw * this.vw + this.vh * this.vh);
    }

    @Override
    public void setWidth(double w) {
        this.vw = w;
        this.vh = this.vw / this.ar;
        this.computeSize();
        this.scaleFactor = this.size / Math.sqrt(Math.pow(this.sc.getWidth(), 2.0) + Math.pow(this.sc.getHeight(), 2.0));
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void setHeight(double h) {
        this.vh = h;
        this.vw = this.vh * this.ar;
        this.computeSize();
        this.scaleFactor = this.size / Math.sqrt(Math.pow(this.sc.getWidth(), 2.0) + Math.pow(this.sc.getHeight(), 2.0));
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double getWidth() {
        return this.vw;
    }

    @Override
    public double getHeight() {
        return this.vh;
    }

    @Override
    public void sizeTo(double s) {
        this.size = s;
        this.vw = this.size * this.ar / Math.sqrt(this.ar * this.ar + 1.0);
        this.vh = this.size / Math.sqrt(this.ar * this.ar + 1.0);
        this.scaleFactor = this.size / Math.sqrt(Math.pow(this.sc.getWidth(), 2.0) + Math.pow(this.sc.getHeight(), 2.0));
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void reSize(double factor) {
        this.size *= factor;
        this.vw = this.size * this.ar / Math.sqrt(this.ar * this.ar + 1.0);
        this.vh = this.size / Math.sqrt(this.ar * this.ar + 1.0);
        this.scaleFactor = this.size / Math.sqrt(Math.pow(this.sc.getWidth(), 2.0) + Math.pow(this.sc.getHeight(), 2.0));
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public double[] getBounds() {
        double[] res = new double[]{this.vx - this.vw / 2.0, this.vy + this.vh / 2.0, this.vx + this.vw / 2.0, this.vy - this.vh / 2.0};
        return res;
    }

    public void setComponent(JComponent c) {
        this.sc = c;
        this.sc.setDoubleBuffered(false);
        this.vw = (double)this.sc.getWidth() * this.scaleFactor;
        this.vh = (double)this.sc.getHeight() * this.scaleFactor;
        this.ar = this.vw / this.vh;
        this.computeSize();
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public JComponent getComponent() {
        return this.sc;
    }

    public void setZoomSensitive(boolean b) {
        if (this.zoomSensitive != b) {
            this.zoomSensitive = b;
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public boolean isZoomSensitive() {
        return this.zoomSensitive;
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - this.size <= eb && this.vx + this.size >= wb && this.vy - this.size <= nb && this.vy + this.size >= sb;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].cw = (int)Math.round(this.vw / 2.0 * this.coef);
            this.pc[i].ch = (int)Math.round(this.vh / 2.0 * this.coef);
        } else {
            this.pc[i].cw = (int)Math.round(this.vw / 2.0);
            this.pc[i].ch = (int)Math.round(this.vh / 2.0);
        }
        float x1 = -this.pc[i].cw;
        float y1 = -this.pc[i].ch;
        float x2 = this.pc[i].cw;
        float y2 = this.pc[i].ch;
        this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
        this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
        this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
        this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
        if (this.pc[i].p == null) {
            this.pc[i].p = new Polygon(this.xcoords, this.ycoords, 4);
        } else {
            for (int j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].p.xpoints[j] = this.xcoords[j];
                this.pc[i].p.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].p.invalidate();
        }
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].lcw = (int)Math.round(this.vw / 2.0 * this.coef);
            this.pc[i].lch = (int)Math.round(this.vh / 2.0 * this.coef);
        } else {
            this.pc[i].lcw = (int)Math.round(this.vw / 2.0);
            this.pc[i].lch = (int)Math.round(this.vh / 2.0);
        }
        float x1 = -this.pc[i].lcw;
        float y1 = -this.pc[i].lch;
        float x2 = this.pc[i].lcw;
        float y2 = this.pc[i].lch;
        this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        if (this.pc[i].lp == null) {
            this.pc[i].lp = new Polygon(this.xcoords, this.ycoords, 4);
        } else {
            for (int j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].lp.xpoints[j] = this.xcoords[j];
                this.pc[i].lp.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].lp.invalidate();
        }
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].cw >= 1 || this.pc[i].ch >= 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0) < (double)0.01f) {
                this.trueCoef = 1.0;
            }
            if (this.trueCoef != 1.0) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                if (this.orient != 0.0) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawPolygon(this.pc[i].p);
                            g.setStroke(stdS);
                        } else {
                            g.drawPolygon(this.pc[i].p);
                        }
                    }
                    g.setComposite(acO);
                } else {
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawPolygon(this.pc[i].p);
                            g.setStroke(stdS);
                        } else {
                            g.drawPolygon(this.pc[i].p);
                        }
                    }
                }
            } else if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                if (this.orient == 0.0) {
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                } else {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].p);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].p);
                    }
                }
                g.setComposite(acO);
            } else {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                if (this.orient == 0.0) {
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                } else {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].p);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].p);
                    }
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(this.pc[i].cx, this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].lcw >= 1 || this.pc[i].lch >= 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0) < (double)0.01f) {
                this.trueCoef = 1.0;
            }
            if (this.trueCoef != 1.0) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                if (this.orient != 0.0) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawPolygon(this.pc[i].lp);
                            g.setStroke(stdS);
                        } else {
                            g.drawPolygon(this.pc[i].lp);
                        }
                    }
                    g.setComposite(acO);
                } else {
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawPolygon(this.pc[i].lp);
                            g.setStroke(stdS);
                        } else {
                            g.drawPolygon(this.pc[i].lp);
                        }
                    }
                }
            } else if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                if (this.orient == 0.0) {
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                } else {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].lp);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].lp);
                    }
                }
                g.setComposite(acO);
            } else {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                if (this.orient == 0.0) {
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                } else {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                    g.setTransform(this.at);
                    this.sc.paint(g);
                    g.setTransform(stdT);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].lp);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].lp);
                    }
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(this.pc[i].lcx, this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Shape getJava2DShape() {
        return new Rectangle2D.Double(this.vx - this.vw / 2.0, this.vy - this.vh / 2.0, this.vw, this.vh);
    }

    @Override
    public Object clone() {
        VSwingComponent<T> res = new VSwingComponent<T>(this.vx, this.vy, this.vz, this.sc, this.scaleFactor, this.orient, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.setWidth(this.vw);
        res.setHeight(this.vh);
        res.borderColor = this.borderColor;
        res.cursorInsideColor = this.cursorInsideColor;
        res.bColor = this.bColor;
        res.setZoomSensitive(this.zoomSensitive);
        return res;
    }

    public static void setSizeToPreferred(Component cmp) {
        cmp.setSize(cmp.getPreferredSize());
    }

    public static void forceLayout(Container container) {
        container.doLayout();
    }
}

