/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.infrastructure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ComProtocolKind implements Enumerator
{
    NONE(0, "none", "none"),
    ENV(1, "env", "env"),
    BUFFER(2, "buffer", "buffer"),
    RDV(3, "rdv", "rdv"),
    MULTI_RDV(4, "multi_rdv", "multi_rdv");

    public static final int NONE_VALUE = 0;
    public static final int ENV_VALUE = 1;
    public static final int BUFFER_VALUE = 2;
    public static final int RDV_VALUE = 3;
    public static final int MULTI_RDV_VALUE = 4;
    private static final ComProtocolKind[] VALUES_ARRAY;
    public static final List<ComProtocolKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComProtocolKind[]{NONE, ENV, BUFFER, RDV, MULTI_RDV};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComProtocolKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComProtocolKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComProtocolKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComProtocolKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComProtocolKind get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ENV;
            }
            case 2: {
                return BUFFER;
            }
            case 3: {
                return RDV;
            }
            case 4: {
                return MULTI_RDV;
            }
        }
        return null;
    }

    private ComProtocolKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

