/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.widgets;

import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VCircle;
import fr.inria.zvtm.glyphs.VPolygon;
import fr.inria.zvtm.glyphs.VTextOr;
import fr.inria.zvtm.widgets.PieMenu;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;

public class PieMenuP
extends PieMenu {
    public PieMenuP(String[] stringLabels, Point2D.Double menuCenterCoordinates, String vsName, VirtualSpaceManager vsm, double radius, double startAngle, Color fillColor, Color borderColor, Color fillSColor, Color borderSColor, Color labelColor, float alphaT, double sensitRadius, Font font) {
        this.vs = vsm.getVirtualSpace(vsName);
        double vx = menuCenterCoordinates.x;
        double vy = menuCenterCoordinates.y;
        this.items = new VPolygon[stringLabels.length];
        this.labels = new VTextOr[stringLabels.length];
        double angle = startAngle;
        double angleDelta = Math.PI * 2 / (double)stringLabels.length;
        double pieMenuRadius = radius;
        for (int i = 0; i < this.labels.length; ++i) {
            double textAngle;
            Point2D.Double[] coords = new Point2D.Double[]{new Point2D.Double(vx, vy), new Point2D.Double(vx + Math.cos(angle) * pieMenuRadius, vy + Math.sin(angle) * pieMenuRadius), new Point2D.Double(vx + Math.cos(angle += angleDelta) * pieMenuRadius, vy + Math.sin(angle) * pieMenuRadius)};
            this.items[i] = new VPolygon(coords, 0, fillColor, borderColor, alphaT);
            this.items[i].setCursorInsideFillColor(fillSColor);
            this.items[i].setCursorInsideHighlightColor(borderSColor);
            this.vs.addGlyph(this.items[i], false, false);
            if (stringLabels[i] == null || stringLabels[i].length() <= 0) continue;
            if (this.orientText) {
                textAngle = angle - angleDelta / 2.0;
                if (angle > 1.5707963267948966) {
                    if (angle > Math.PI) {
                        if (angle < 4.71238898038469) {
                            textAngle -= Math.PI;
                        }
                    } else {
                        textAngle += Math.PI;
                    }
                }
                this.labels[i] = new VTextOr(vx + Math.cos(angle - angleDelta / 2.0) * pieMenuRadius / 2.0, vy + Math.sin(angle - angleDelta / 2.0) * pieMenuRadius / 2.0, 0, labelColor, stringLabels[i], textAngle, 1);
            } else {
                textAngle = angle - angleDelta / 2.0;
                if (angle > 1.5707963267948966) {
                    if (angle > Math.PI) {
                        if (angle < 4.71238898038469) {
                            textAngle -= Math.PI;
                        }
                    } else {
                        textAngle += Math.PI;
                    }
                }
                this.labels[i] = new VTextOr(vx + Math.cos(angle - angleDelta / 2.0) * pieMenuRadius / 2.0, vy + Math.sin(angle - angleDelta / 2.0) * pieMenuRadius / 2.0, 0, labelColor, stringLabels[i], 0.0, 1);
            }
            this.labels[i].setBorderColor(borderColor);
            this.labels[i].setFont(font);
            this.labels[i].setSensitivity(false);
            this.vs.addGlyph(this.labels[i]);
        }
        this.boundary = new VCircle(vx, vy, 0, pieMenuRadius * sensitRadius * 2.0, Color.white);
        this.boundary.setVisible(false);
        this.vs.addGlyph(this.boundary);
        this.vs.atBottom(this.boundary);
    }

    public PieMenuP(String[] stringLabels, Point2D.Double menuCenterCoordinates, String vsName, VirtualSpaceManager vsm, double radius, double startAngle, Color[] fillColors, Color[] borderColors, Color[] fillSColors, Color[] borderSColors, Color[] labelColors, float alphaT, double sensitRadius, Font font) {
        this.vs = vsm.getVirtualSpace(vsName);
        double vx = menuCenterCoordinates.x;
        double vy = menuCenterCoordinates.y;
        this.items = new VPolygon[stringLabels.length];
        this.labels = new VTextOr[stringLabels.length];
        double angle = startAngle;
        double angleDelta = Math.PI * 2 / (double)stringLabels.length;
        double pieMenuRadius = radius;
        for (int i = 0; i < this.labels.length; ++i) {
            Point2D.Double[] coords = new Point2D.Double[]{new Point2D.Double(vx, vy), new Point2D.Double(vx + Math.cos(angle) * pieMenuRadius, vy + Math.sin(angle) * pieMenuRadius), new Point2D.Double(vx + Math.cos(angle += angleDelta) * pieMenuRadius, vy + Math.sin(angle) * pieMenuRadius)};
            this.items[i] = new VPolygon(coords, 0, fillColors[i], borderColors[i], alphaT);
            this.items[i].setCursorInsideFillColor(fillSColors[i]);
            this.items[i].setCursorInsideHighlightColor(borderSColors[i]);
            this.vs.addGlyph(this.items[i], false, false);
            if (stringLabels[i] == null || stringLabels[i].length() <= 0) continue;
            if (this.orientText) {
                double textAngle = angle - angleDelta / 2.0;
                if (angle > 1.5707963267948966) {
                    if (angle > Math.PI) {
                        if (angle < 4.71238898038469) {
                            textAngle -= Math.PI;
                        }
                    } else {
                        textAngle += Math.PI;
                    }
                }
                this.labels[i] = new VTextOr(vx + Math.cos(angle - angleDelta / 2.0) * pieMenuRadius / 2.0, vy + Math.sin(angle - angleDelta / 2.0) * pieMenuRadius / 2.0, 0, labelColors[i], stringLabels[i], textAngle, 1);
            } else {
                this.labels[i] = new VTextOr(vx + Math.cos(angle - angleDelta / 2.0) * pieMenuRadius / 2.0, vy + Math.sin(angle - angleDelta / 2.0) * pieMenuRadius / 2.0, 0, labelColors[i], stringLabels[i], 0.0, 1);
            }
            this.labels[i].setBorderColor(borderColors[i]);
            this.labels[i].setFont(font);
            this.labels[i].setSensitivity(false);
            this.vs.addGlyph(this.labels[i]);
        }
        this.boundary = new VCircle(vx, vy, 0, pieMenuRadius * sensitRadius * 2.0, Color.white);
        this.boundary.setVisible(false);
        this.vs.addGlyph(this.boundary);
        this.vs.atBottom(this.boundary);
    }

    public PieMenuP(String[] stringLabels, Point2D.Double menuCenterCoordinates, String vsName, VirtualSpaceManager vsm, double radius, double startAngle, Color fillColor, Color borderColor, Color fillSColor, Color borderSColor, Color labelColor, float alphaT, double sensitRadius, Font font, Point2D.Double[] labelOffsets) {
        this.vs = vsm.getVirtualSpace(vsName);
        double vx = menuCenterCoordinates.x;
        double vy = menuCenterCoordinates.y;
        this.items = new VPolygon[stringLabels.length];
        this.labels = new VTextOr[stringLabels.length];
        double angle = startAngle;
        double angleDelta = Math.PI * 2 / (double)stringLabels.length;
        double pieMenuRadius = radius;
        for (int i = 0; i < this.labels.length; ++i) {
            double textAngle;
            Point2D.Double[] coords = new Point2D.Double[]{new Point2D.Double(vx, vy), new Point2D.Double(vx + Math.cos(angle) * pieMenuRadius, vy + Math.sin(angle) * pieMenuRadius), new Point2D.Double(vx + Math.cos(angle += angleDelta) * pieMenuRadius, vy + Math.sin(angle) * pieMenuRadius)};
            this.items[i] = new VPolygon(coords, 0, fillColor, borderColor, alphaT);
            this.items[i].setCursorInsideFillColor(fillSColor);
            this.items[i].setCursorInsideHighlightColor(borderSColor);
            this.vs.addGlyph(this.items[i], false, false);
            if (stringLabels[i] == null || stringLabels[i].length() <= 0) continue;
            if (this.orientText) {
                textAngle = angle - angleDelta / 2.0;
                if (angle > 1.5707963267948966) {
                    if (angle > Math.PI) {
                        if (angle < 4.71238898038469) {
                            textAngle -= Math.PI;
                        }
                    } else {
                        textAngle += Math.PI;
                    }
                }
                this.labels[i] = new VTextOr(vx + Math.cos(angle - angleDelta / 2.0) * pieMenuRadius / 2.0 + labelOffsets[i].x, vy + Math.sin(angle - angleDelta / 2.0) * pieMenuRadius / 2.0 + labelOffsets[i].y, 0, labelColor, stringLabels[i], textAngle, 1);
            } else {
                textAngle = angle - angleDelta / 2.0;
                if (angle > 1.5707963267948966) {
                    if (angle > Math.PI) {
                        if (angle < 4.71238898038469) {
                            textAngle -= Math.PI;
                        }
                    } else {
                        textAngle += Math.PI;
                    }
                }
                this.labels[i] = new VTextOr(vx + Math.cos(angle - angleDelta / 2.0) * pieMenuRadius / 2.0 + labelOffsets[i].x, vy + Math.sin(angle - angleDelta / 2.0) * pieMenuRadius / 2.0 + labelOffsets[i].y, 0, labelColor, stringLabels[i], 0.0, 1);
            }
            this.labels[i].setBorderColor(borderColor);
            this.labels[i].setFont(font);
            this.labels[i].setSensitivity(false);
            this.vs.addGlyph(this.labels[i]);
        }
        this.boundary = new VCircle(vx, vy, 0, pieMenuRadius * sensitRadius * 2.0, Color.white);
        this.boundary.setVisible(false);
        this.vs.addGlyph(this.boundary);
        this.vs.atBottom(this.boundary);
    }

    public PieMenuP(String[] stringLabels, Point2D.Double menuCenterCoordinates, String vsName, VirtualSpaceManager vsm, double radius, double startAngle, Color[] fillColors, Color[] borderColors, Color[] fillSColors, Color[] borderSColors, Color[] labelColors, float alphaT, double sensitRadius, Font font, Point2D.Double[] labelOffsets) {
        this.vs = vsm.getVirtualSpace(vsName);
        double vx = menuCenterCoordinates.x;
        double vy = menuCenterCoordinates.y;
        this.items = new VPolygon[stringLabels.length];
        this.labels = new VTextOr[stringLabels.length];
        double angle = startAngle;
        double angleDelta = Math.PI * 2 / (double)stringLabels.length;
        double pieMenuRadius = radius;
        for (int i = 0; i < this.labels.length; ++i) {
            Point2D.Double[] coords = new Point2D.Double[]{new Point2D.Double(vx, vy), new Point2D.Double(vx + Math.cos(angle) * pieMenuRadius, vy + Math.sin(angle) * pieMenuRadius), new Point2D.Double(vx + Math.cos(angle += angleDelta) * pieMenuRadius, vy + Math.sin(angle) * pieMenuRadius)};
            this.items[i] = new VPolygon(coords, 0, fillColors[i], borderColors[i], alphaT);
            this.items[i].setCursorInsideFillColor(fillSColors[i]);
            this.items[i].setCursorInsideHighlightColor(borderSColors[i]);
            this.vs.addGlyph(this.items[i], false, false);
            if (stringLabels[i] == null || stringLabels[i].length() <= 0) continue;
            if (this.orientText) {
                double textAngle = angle - angleDelta / 2.0;
                if (angle > 1.5707963267948966) {
                    if (angle > Math.PI) {
                        if (angle < 4.71238898038469) {
                            textAngle -= Math.PI;
                        }
                    } else {
                        textAngle += Math.PI;
                    }
                }
                this.labels[i] = new VTextOr(vx + Math.cos(angle - angleDelta / 2.0) * pieMenuRadius / 2.0 + labelOffsets[i].x, vy + Math.sin(angle - angleDelta / 2.0) * pieMenuRadius / 2.0 + labelOffsets[i].y, 0, labelColors[i], stringLabels[i], textAngle, 1);
            } else {
                this.labels[i] = new VTextOr(vx + Math.cos(angle - angleDelta / 2.0) * pieMenuRadius / 2.0 + labelOffsets[i].x, vy + Math.sin(angle - angleDelta / 2.0) * pieMenuRadius / 2.0 + labelOffsets[i].y, 0, labelColors[i], stringLabels[i], 0.0, 1);
            }
            this.labels[i].setBorderColor(borderColors[i]);
            this.labels[i].setFont(font);
            this.labels[i].setSensitivity(false);
            this.vs.addGlyph(this.labels[i]);
        }
        this.boundary = new VCircle(vx, vy, 0, pieMenuRadius * sensitRadius * 2.0, Color.white);
        this.boundary.setVisible(false);
        this.vs.addGlyph(this.boundary);
        this.vs.atBottom(this.boundary);
    }
}

