/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.overview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationSection;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class OverviewWorkspaceDataSection
extends AbstractConfigurationSection {
    private StringFieldEditor fWorkspaceRootLocationStringField;
    private StringFieldEditor fWorkspaceOutputLocationStringField;

    public OverviewWorkspaceDataSection(AbstractConfigurationPage configurationPage) {
        super(configurationPage);
    }

    @Override
    public String getSectionTitle() {
        return "Workspace Data";
    }

    @Override
    public String getSectionDescription() {
        return "Enter forlders name for workspace configuration";
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        String root = ResourcesPlugin.getWorkspace().getRoot().getLocation().append("<project-folder-name>").toString();
        String toolTipText = "Name of the subfolder in the root and output folders";
        String toolTipText2 = "Name of the subfolder in the root folder";
        String toolTipText3 = "Name of the subfolder in the output folder";
        this.setToolTipText(toolTipText);
        this.fWorkspaceRootLocationStringField = new StringFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_WORKSPACE_ROOT_LOCATION", "Location :", parent, root);
        this.fWorkspaceRootLocationStringField.setEnabled(false);
        this.fWorkspaceRootLocationStringField.setToolTipText(toolTipText2);
        this.fWorkspaceRootLocationStringField.setEmptyStringAllowed(false);
        this.addField(this.fWorkspaceRootLocationStringField);
        this.fWorkspaceOutputLocationStringField = new StringFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_WORKSPACE_OUTPUT_FOLDER_NAME", "Output :", parent, "output");
        this.fWorkspaceOutputLocationStringField.setToolTipText(toolTipText2);
        this.addField(this.fWorkspaceOutputLocationStringField);
        this.fWorkspaceOutputLocationStringField.setEmptyStringAllowed(false);
        if (this.getConfigurationPage().isEnabledSymbexDeveloperMode()) {
            StringFieldEditor folderNameStringFieldEditor = new StringFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_WORKSPACE_LOG_FOLDER_NAME", "Log :", parent, "log");
            folderNameStringFieldEditor.setToolTipText(toolTipText3);
            this.addField(folderNameStringFieldEditor);
            folderNameStringFieldEditor.setEmptyStringAllowed(false);
            folderNameStringFieldEditor = new StringFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_WORKSPACE_DEBUG_FOLDER_NAME", "Debug :", parent, "debug");
            folderNameStringFieldEditor.setToolTipText(toolTipText3);
            this.addField(folderNameStringFieldEditor);
            folderNameStringFieldEditor.setEmptyStringAllowed(false);
        }
    }

    @Override
    public void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_WORKSPACE_ROOT_LOCATION", "<workspace-root-location>");
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_WORKSPACE_OUTPUT_FOLDER_NAME", "output");
        if (this.getConfigurationPage().isEnabledSymbexDeveloperMode()) {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_WORKSPACE_LOG_FOLDER_NAME", "log");
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_WORKSPACE_DEBUG_FOLDER_NAME", "debug");
        }
    }

    public void updateWorkspaceRootPath(IResource resource) {
        String projectLocation = resource.getProject().getLocation().toString();
        this.fWorkspaceRootLocationStringField.setStringValue(projectLocation);
        this.updateWorkspaceOutputPath(resource);
    }

    public void updateWorkspaceRootPath(String modelPath) {
        Path path;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)(path = new Path(modelPath)));
        if (resource != null && resource.exists()) {
            this.fWorkspaceRootLocationStringField.setStringValue(resource.getProject().getLocation().toString());
            if ("output".equals(this.fWorkspaceOutputLocationStringField.getStringValue())) {
                this.updateWorkspaceOutputPath(resource);
            }
        } else if (root.getLocation().isPrefixOf((IPath)path)) {
            path = root.getLocation().append(path.segment(path.matchingFirstSegments(root.getLocation())));
            this.fWorkspaceRootLocationStringField.setStringValue(path.toString());
        } else {
            this.fWorkspaceRootLocationStringField.setStringValue(root.getLocation().append("<project-folder-name>").toString());
        }
        this.fWorkspaceRootLocationStringField.updateLaunchConfigurationDialog();
    }

    public void updateWorkspaceOutputPath(IResource resource) {
        IContainer parentResource = resource.getParent();
        if (!(!(resource instanceof IFile) || resource.getProject() == parentResource || !this.fWorkspaceOutputLocationStringField.getStringValue().endsWith("output") || parentResource.getName().endsWith("src") || parentResource.getName().endsWith("source") || parentResource.getName().endsWith("model") || parentResource.getName().endsWith("spec") || parentResource.getName().endsWith("specification"))) {
            this.fWorkspaceOutputLocationStringField.setStringValue(String.valueOf(parentResource.getProjectRelativePath().toString()) + '/' + "output");
        }
    }

    @Override
    public void initializeFromImpl(ILaunchConfiguration configuration) {
        try {
            String specMainFileLocation = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "<spec-model-file-location>");
            this.updateWorkspaceRootPath(specMainFileLocation);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
    }

    @Override
    public boolean isValidImpl(ILaunchConfiguration launchConfig) {
        return true;
    }
}

