/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.osgi.util.NLS;

public class JavaLaunchDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NLS.bind((String)"{0}...", (Object[])new String[]{configuration.getName()}), 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Verifying_launch_attributes____1);
            String mainTypeName = this.verifyMainTypeName(configuration);
            IVMRunner runner = this.getVMRunner(configuration, mode);
            File workingDir = this.verifyWorkingDirectory(configuration);
            String workingDirName = null;
            if (workingDir != null) {
                workingDirName = workingDir.getAbsolutePath();
            }
            String[] envp = this.getEnvironment(configuration);
            String pgmArgs = this.getProgramArguments(configuration);
            String vmArgs = this.getVMArguments(configuration);
            ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
            Map<String, Object> vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
            String[][] paths = this.getClasspathAndModulepath(configuration);
            VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, this.getClasspath(configuration));
            runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
            runConfig.setEnvironment(envp);
            runConfig.setVMArguments(execArgs.getVMArgumentsArray());
            runConfig.setWorkingDirectory(workingDirName);
            runConfig.setVMSpecificAttributesMap(vmAttributesMap);
            try {
                IJavaProject proj = JavaRuntime.getJavaProject(configuration);
                if (proj != null) {
                    String modName;
                    IModuleDescription module = proj == null ? null : proj.getModuleDescription();
                    String string = modName = module == null ? null : module.getElementName();
                    if (modName != null) {
                        runConfig.setModuleDescription(modName);
                    }
                }
            }
            catch (CoreException coreException) {}
            if (!JavaRuntime.isModularConfiguration(configuration)) {
                runConfig.setBootClassPath(this.getBootpath(configuration));
            } else {
                runConfig.setModulepath(paths[1]);
            }
            if (monitor.isCanceled()) {
                return;
            }
            this.prepareStopInMain(configuration);
            monitor.worked(1);
            monitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Creating_source_locator____2);
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            runner.run(runConfig, launch, monitor);
            if (monitor.isCanceled()) {
                return;
            }
        }
        finally {
            monitor.done();
        }
    }
}

