/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.debug;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.observable.FXObservableUtil;

public class DistanceMeasuringUtil
extends Region {
    private Subscription boundsChangeSub;
    private Region line1;
    private Region line2;
    private Region line3;
    private Double l1 = null;
    private Double l2 = null;
    private Label text;
    private Region draggedNode;
    private double startVal;
    private double startLocation;

    public DistanceMeasuringUtil(Parent p) {
        this.setMouseTransparent(true);
        this.line1 = new Region();
        this.line1.setStyle("-fx-background-color: rgba(0,0,0,0.0), rgba(255,0,0,0.0), rgba(255,0,0,1); -fx-background-insets: 0, 0 8 0 8, 0 12 0 12; -fx-cursor: h-resize");
        this.line1.setOnMousePressed(e -> {
            this.draggedNode = this.line1;
            this.startLocation = e.getScreenX();
            this.startVal = this.l1;
        });
        this.line1.setOnMouseDragged(e -> {
            if (this.draggedNode == this.line1) {
                this.l1 = this.startVal + (e.getScreenX() - this.startLocation);
                this.requestLayout();
            }
        });
        this.line1.setOnMouseReleased(e -> {
            Region region = this.draggedNode = null;
        });
        this.line2 = new Region();
        this.line2.setStyle("-fx-background-color: rgba(0,0,0,0), rgba(255,0,0,0), rgba(255,0,0,1); -fx-background-insets: 0, 0 8 0 8, 0 12 0 12; -fx-cursor: h-resize");
        this.line2.setOnMousePressed(e -> {
            this.draggedNode = this.line2;
            this.startLocation = e.getScreenX();
            this.startVal = this.l2;
        });
        this.line2.setOnMouseDragged(e -> {
            if (this.draggedNode == this.line2) {
                this.l2 = this.startVal + (e.getScreenX() - this.startLocation);
                this.requestLayout();
            }
        });
        this.line2.setOnMouseReleased(e -> {
            this.draggedNode = null;
        });
        this.line3 = new Region();
        this.line3.setStyle("-fx-background-color: rgba(255,0,0);");
        this.text = new Label();
        this.text.setStyle("-fx-text-fill: rgba(255,0,0); -fx-font-size: 10px");
        this.text.setText("0px");
        this.setManaged(false);
        this.boundsChangeSub = FXObservableUtil.onChange((ObservableValue)p.layoutBoundsProperty(), this::handleBoundsChange);
        this.getChildren().addAll((Object[])new Node[]{this.line1, this.line2, this.line3, this.text});
        FXObservableUtil.onChange((ObservableValue)this.sceneProperty(), this::handleSceneChange);
    }

    private void handleSceneChange(Scene ol, Scene ne) {
        ne.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.COMMAND) {
                this.setMouseTransparent(false);
            } else if (e.getCode() == KeyCode.LEFT) {
                if (this.draggedNode == this.line1) {
                    this.l1 = this.l1 - 1.0;
                    this.startVal -= 1.0;
                    this.requestLayout();
                    e.consume();
                }
                if (this.draggedNode == this.line2) {
                    this.l2 = this.l2 - 1.0;
                    this.startVal -= 1.0;
                    this.requestLayout();
                    e.consume();
                }
            } else if (e.getCode() == KeyCode.RIGHT) {
                if (this.draggedNode == this.line1) {
                    this.l1 = this.l1 + 1.0;
                    this.startVal += 1.0;
                    this.requestLayout();
                    e.consume();
                }
                if (this.draggedNode == this.line2) {
                    this.l2 = this.l2 + 1.0;
                    this.startVal += 1.0;
                    this.requestLayout();
                    e.consume();
                }
            }
        });
        ne.addEventFilter(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode() == KeyCode.COMMAND) {
                this.setMouseTransparent(true);
            }
        });
    }

    private void handleBoundsChange(Bounds b) {
        this.resize(b.getWidth(), b.getHeight());
    }

    public void dispose() {
        this.boundsChangeSub.dispose();
    }

    protected void layoutChildren() {
        double areaWidth = 25.0;
        if (this.l1 == null) {
            this.l1 = this.getWidth() / 2.0 - areaWidth / 2.0;
        }
        if (this.l2 == null) {
            this.l2 = this.getWidth() / 2.0 + areaWidth / 2.0;
        }
        this.line1.resizeRelocate(this.l1.doubleValue(), 0.0, areaWidth, this.getHeight());
        this.line2.resizeRelocate(this.l2.doubleValue(), 0.0, areaWidth, this.getHeight());
        this.line3.resizeRelocate(Math.min(this.l1, this.l2) + areaWidth / 2.0, this.getHeight() / 2.0, Math.abs(this.l1 - this.l2), 1.0);
        this.text.setText(String.format("%.2f px", Math.abs(this.l1 - this.l2)));
        double w = this.text.prefWidth(-1.0);
        double h = this.text.prefHeight(-1.0);
        this.text.resizeRelocate(Math.min(this.l1, this.l2) + areaWidth / 2.0 + Math.abs(this.l1 - this.l2) / 2.0 - w / 2.0, this.getHeight() / 2.0 + 3.0, w, h);
    }
}

