/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.compiler;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.fx.ide.fxgraph.FXGraphStandaloneSetupGenerated;
import org.eclipse.fx.ide.fxgraph.converter.IFXMLFile;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxml.compiler.FXGraphGenerator;
import org.eclipse.fx.ide.fxml.compiler.FXGraphJavaGenerator;
import org.eclipse.fx.ide.fxml.compiler.FXMLSaxHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FXGraphCompiler {
    @Inject
    private Provider<ResourceSet> resourceSetProvider;

    public static void main(String[] args) {
        Injector injector = new FXGraphStandaloneSetupGenerated().createInjectorAndDoEMFRegistration();
        FXGraphCompiler main = (FXGraphCompiler)injector.getInstance(FXGraphCompiler.class);
        try {
            main.compile(injector, args[0], args[1], null);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void compileFXML(Injector injector, final String string, final String sourcePrefix, String outputPrefix, boolean debug) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(true);
        SAXParser p = f.newSAXParser();
        FXMLSaxHandler h = (FXMLSaxHandler)injector.getInstance(FXMLSaxHandler.class);
        IFXMLFile fi = new IFXMLFile(){

            public String getPackagename() {
                if (sourcePrefix == null) {
                    return "dummy";
                }
                String filePath = new File(string).getParent();
                String packagename = filePath.substring(sourcePrefix.length());
                return (packagename = packagename.replace('\\', '.').replace('/', '.')).startsWith(".") ? packagename.substring(1) : packagename;
            }

            public String getName() {
                return new File(string).getName();
            }

            public InputStream getContent() {
                try {
                    return new FileInputStream(string);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        h.setFile(fi);
        p.parse(fi.getContent(), (DefaultHandler)h);
        if (debug) {
            String data = new FXGraphGenerator().generate(h.model).toString();
            System.err.println("============");
            System.err.println(new String(data.getBytes()));
            this.generateJavaFile(h.model, string, sourcePrefix, outputPrefix);
        } else {
            this.generateJavaFile(h.model, string, sourcePrefix, outputPrefix);
        }
    }

    public void compileFXGraph(Injector injector, String inputFile, String inputOriginalFile, String sourcePrefix, String outputPrefix) throws SAXException, IOException, ParserConfigurationException {
        ResourceSet set = (ResourceSet)this.resourceSetProvider.get();
        Resource resource = set.getResource(URI.createURI((String)inputFile), true);
        this.generateJavaFile((Model)resource.getContents().get(0), inputOriginalFile, sourcePrefix, outputPrefix);
    }

    public void generateJavaFile(Model m, String inputOriginalFile, String sourcePrefix, String outputPrefix) throws IOException {
        FXGraphJavaGenerator c = new FXGraphJavaGenerator(m);
        String outFile = inputOriginalFile.replaceAll("fxgraph$", "java").replaceAll("fxml$", "java");
        if (outputPrefix != null) {
            String filePath = new File(outFile).getAbsolutePath();
            String packagename = filePath.substring(sourcePrefix.length() + 1);
            File f = new File(outputPrefix, packagename);
            f.getParentFile().mkdirs();
            outFile = f.getAbsolutePath();
        }
        FileOutputStream out = new FileOutputStream(outFile);
        out.write(c.generate().toString().getBytes());
        out.close();
    }

    public void compile(Injector injector, String filename, String sourcePrefix, String outputPrefix) throws SAXException, IOException, ParserConfigurationException {
        if (filename.endsWith("fxml")) {
            this.compileFXML(injector, filename, sourcePrefix, outputPrefix, false);
        } else {
            this.compileFXGraph(injector, filename, filename, sourcePrefix, outputPrefix);
        }
    }
}

