/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.edit.command.plugin.contract;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.model.Contract;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.edit.command.plugin.PluginChangeWrapperCommand;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommand;
import org.eclipse.egf.pde.plugin.extension.IContractElementRefExtensionFactory;
import org.eclipse.egf.pde.plugin.extension.IContractExtensionFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContractWrapperCommand
extends PluginChangeWrapperCommand {
    protected AbstractContractWrapperCommand(EditingDomain domain_p, EObject modelElement_p, EStructuralFeature feature_p, Object value_p) {
        super(domain_p, modelElement_p, feature_p, value_p);
    }

    protected String getContractId() {
        String contractId = null;
        NamedModelElementWithId modelElement = this.getModelElement();
        if (modelElement instanceof Contract) {
            contractId = modelElement.getId();
        } else if (modelElement instanceof ContractElement) {
            contractId = ((NamedModelElementWithId)modelElement.eContainer()).getId();
        }
        return contractId;
    }

    protected List<IPluginChangesCommand> getExecutableCommandList(ContractElement contractElement_p) {
        ArrayList<IPluginChangesCommand> commands = new ArrayList<IPluginChangesCommand>(1);
        commands.addAll(this.handleContractElementReferences(contractElement_p));
        commands.addAll(this.handleContractElement(contractElement_p));
        return commands;
    }

    protected List<IPluginChangesCommand> handleContractElement(ContractElement contractElement_p) {
        ArrayList<IPluginChangesCommand> commands = new ArrayList<IPluginChangesCommand>();
        String contractElementId = contractElement_p.getId();
        String contractElementName = contractElement_p.getName();
        String contractElementType = contractElement_p.getContractType().getTypeHolderClassName();
        String isMandatory = Boolean.toString(contractElement_p.isMandatory());
        EList contractElementReferenceIds = contractElement_p.getContractReferenceIds();
        String contractId = this.getContractId();
        IContractExtensionFactory contractExtensionHelper = this.getMDSoFaPde().getContractExtensionHelper();
        commands.add(contractExtensionHelper.unsetContractElement(contractId, contractElementId));
        commands.add(contractExtensionHelper.setContractElement(contractId, contractElementId, contractElementName, contractElementType, (List)contractElementReferenceIds, isMandatory, contractElement_p.getDescription()));
        return commands;
    }

    protected List<IPluginChangesCommand> handleContractElementReferences(ContractElement contractElement_p) {
        ArrayList<IPluginChangesCommand> commands = new ArrayList<IPluginChangesCommand>();
        EList contractElementReferenceIds = contractElement_p.getContractReferenceIds();
        EList contractElementReferences = contractElement_p.getContractElementReferences();
        IContractElementRefExtensionFactory contractElementRefExtHelper = this.getMDSoFaPde().getContractElementRefExtensionHelper();
        ArrayList<String> upToDateContractElementReferenceIds = new ArrayList<String>(0);
        for (ContractElementReference contractElementReference : contractElementReferences) {
            String contractElementReferenceId = contractElementReference.getId();
            contractElementReferenceIds.add(contractElementReferenceId);
            upToDateContractElementReferenceIds.add(contractElementReferenceId);
            commands.add(contractElementRefExtHelper.setContractElementReferenceExtension(contractElementReferenceId, contractElementReference.getReferencedContractElementId(), contractElementReference.getReferencedFactoryComponentId()));
        }
        Iterator iteratorOvercontractElementReferenceId = contractElementReferenceIds.iterator();
        while (iteratorOvercontractElementReferenceId.hasNext()) {
            String currentContractElementReferenceId = (String)iteratorOvercontractElementReferenceId.next();
            if (upToDateContractElementReferenceIds.contains(currentContractElementReferenceId)) continue;
            commands.add(contractElementRefExtHelper.unsetContractElementReferenceExtension(currentContractElementReferenceId));
            iteratorOvercontractElementReferenceId.remove();
        }
        return commands;
    }

    @Override
    public boolean doCanUndo() {
        return true;
    }
}

