/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.internal.drop;

import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.pattern.refactoring.move.MoveInfo;
import org.eclipse.egf.pattern.refactoring.move.MoveProcessor;
import org.eclipse.egf.pattern.refactoring.move.MoveRefactoring;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternLibraryDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private MoveRefactoring _moveRefactoring;

    public IStatus handleDrop(CommonDropAdapter dropAdapter_p, DropTargetEvent dropTargetEvent_p, Object target_p) {
        CreateChangeOperation changeOperation = new CreateChangeOperation((Refactoring)this._moveRefactoring);
        PerformChangeOperation performOperation = new PerformChangeOperation(changeOperation);
        IStatus resultingStatus = Status.CANCEL_STATUS;
        WorkbenchRunnableAdapter runnableAdapter = new WorkbenchRunnableAdapter((IWorkspaceRunnable)performOperation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, (IRunnableWithProgress)runnableAdapter);
            resultingStatus = Status.OK_STATUS;
        }
        catch (Exception exception) {}
        this._moveRefactoring = null;
        return resultingStatus;
    }

    public IStatus validateDrop(Object target_p, int operation_p, TransferData transferType_p) {
        List<AbstractPatternElement> selectedPatternElements = this.handleSelection();
        IStatus resultingStatus = Status.CANCEL_STATUS;
        if (selectedPatternElements == null) {
            return resultingStatus;
        }
        MoveInfo moveInfo = new MoveInfo();
        NamedModelElementWithId target = (NamedModelElementWithId)target_p;
        moveInfo.setDestinationElement(target);
        moveInfo.addElementsToMove(selectedPatternElements);
        MoveProcessor processor = new MoveProcessor(moveInfo);
        this._moveRefactoring = new MoveRefactoring(processor);
        CheckConditionsOperation checkOperation = new CheckConditionsOperation((Refactoring)this._moveRefactoring, 6);
        WorkbenchRunnableAdapter runnableAdapter = new WorkbenchRunnableAdapter((IWorkspaceRunnable)checkOperation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        try {
            runnableAdapter.run((IProgressMonitor)new NullProgressMonitor());
            RefactoringStatus status = checkOperation.getStatus();
            if (status.isOK()) {
                resultingStatus = Status.OK_STATUS;
            }
        }
        catch (Exception exception) {}
        return resultingStatus;
    }

    private List<AbstractPatternElement> handleSelection() {
        List result = null;
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return result;
        }
        List selectedElements = ((IStructuredSelection)selection).toList();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return result;
        }
        for (Object object : selectedElements) {
            if (object instanceof AbstractPatternElement) continue;
            return result;
        }
        result = selectedElements;
        return result;
    }
}

