/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor.codeassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.jet.JETSkeleton;
import org.eclipse.emf.codegen.jet.editor.JETEditorPlugin;
import org.eclipse.emf.codegen.jet.editor.presentation.JETTextEditor;
import org.eclipse.emf.codegen.jet.editor.util.JETCompilerExt;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.template.java.JavaContextType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IFileEditorInput;

public class JETTemplateCompletionProcessor
implements IContentAssistProcessor {
    protected IFile jetFile;
    protected JETTextEditor jetEditor;
    protected IJavaProject javaProject;
    protected JETNature jetNature;
    private TemplateEngine fTemplateEngine;
    private CompletionProposalComparator fComparator;
    private char[] fProposalAutoActivationSet;

    public JETTemplateCompletionProcessor(JETTextEditor editor) {
        this.jetEditor = editor;
        this.setCompletionProposalAutoActivationCharacters(".".toCharArray());
        this.jetFile = ((IFileEditorInput)editor.getEditorInput()).getFile();
        this.javaProject = JavaCore.create((IProject)this.getProject());
        this.jetNature = JETNature.getRuntime((IProject)this.getProject());
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType == null) {
            contextType = new JavaContextType();
            JavaPlugin.getDefault().getTemplateContextRegistry().addContextType(contextType);
        }
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new CompletionProposalComparator();
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    private IProject getProject() {
        if (this.jetFile == null) {
            return null;
        }
        return this.jetFile.getProject();
    }

    protected IJavaProject getJavaProject() {
        if (this.javaProject == null) {
            this.javaProject = JavaCore.create((IProject)this.getProject());
        }
        return this.javaProject;
    }

    protected JETNature getJETNature() {
        if (this.jetNature == null) {
            this.jetNature = JETNature.getRuntime((IProject)this.getProject());
        }
        return this.jetNature;
    }

    protected int findJavaMatchingOffset(JETCompilerExt compiler, String javaSource, ITextViewer viewer, int offset) {
        int javaOffset;
        JETCompilerExt.Range jetRange = compiler.getJETRange(offset, this.jetFile.getFullPath().toString());
        JETCompilerExt.Range javaRange = compiler.getJavaRange(jetRange);
        int n = javaOffset = javaRange == null ? -1 : javaRange.start + (offset - jetRange.start);
        if (javaRange == null) {
            return -1;
        }
        return javaOffset;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        int javaOffset;
        ICompilationUnit compilationUnit;
        block11: {
            if (this.getJavaProject() == null || this.getJETNature() == null) {
                ICompletionProposal[] results = new ICompletionProposal[]{};
                return results;
            }
            IContainer parent = this.jetFile.getParent();
            while (parent != null && !this.jetNature.getTemplateContainers().contains(parent)) {
                parent = parent.getParent();
            }
            if (parent == null) {
                this.jetNature.getTemplateContainers().add(this.jetFile.getParent());
                this.jetNature.setTemplateContainers(this.jetNature.getTemplateContainers());
            }
            if (this.jetNature.getJavaSourceContainer() == null) {
                this.computeJavaSourceContainer();
            }
            String uri = this.jetFile.getLocation().toFile().getAbsoluteFile().toURL().toString();
            String jetSource = viewer.getDocument().get();
            ByteArrayInputStream is = new ByteArrayInputStream(jetSource.getBytes());
            JETCompilerExt jetCompiler = new JETCompilerExt(uri, is);
            jetCompiler.parse();
            ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
            jetCompiler.generate(arrayOutputStream);
            JETSkeleton skeleton = jetCompiler.getSkeleton();
            IPackageFragmentRoot[] roots = this.getJavaProject().getPackageFragmentRoots();
            compilationUnit = this.findCompilationUnit(arrayOutputStream, skeleton, roots);
            javaOffset = this.findJavaMatchingOffset(jetCompiler, arrayOutputStream.toString(), viewer, offset);
            if (javaOffset != -1) break block11;
            return null;
        }
        try {
            CompletionProposalCollector collector = new CompletionProposalCollector(compilationUnit);
            Point selection = viewer.getSelectedRange();
            if (selection.y > 0) {
                collector.setReplacementLength(selection.y);
            }
            compilationUnit.codeComplete(javaOffset, (CompletionRequestor)collector);
            IJavaCompletionProposal[] results = collector.getJavaCompletionProposals();
            if (this.fTemplateEngine != null) {
                results = this.adjustResults(viewer, offset, (ICompletionProposal[])results, compilationUnit, collector);
            }
            viewer.setSelectedRange(offset, 0);
            viewer.revealRange(offset, 10);
            this.setReplacementOffsets(offset, (ICompletionProposal[])results);
            return this.order((ICompletionProposal[])results);
        }
        catch (CoreException e) {
            JETEditorPlugin.getDefault().log((Object)e);
        }
        catch (MalformedURLException e) {
            JETEditorPlugin.getDefault().log(e);
        }
        catch (JETException e) {
            JETEditorPlugin.getDefault().log((Object)e);
        }
        return null;
    }

    private void setReplacementOffsets(int offset, ICompletionProposal[] results) {
        int i = 0;
        while (i < results.length) {
            JavaCompletionProposal proposal;
            if (results[i] instanceof JavaCompletionProposal) {
                proposal = (JavaCompletionProposal)results[i];
                proposal.setReplacementOffset(offset);
            }
            if (results[i] instanceof LazyJavaCompletionProposal) {
                proposal = (LazyJavaCompletionProposal)results[i];
                proposal.setReplacementOffset(offset);
            }
            ++i;
        }
    }

    private ICompletionProposal[] adjustResults(ITextViewer viewer, int offset, ICompletionProposal[] results, ICompilationUnit compilationUnit, CompletionProposalCollector collector) {
        this.fTemplateEngine.reset();
        this.fTemplateEngine.complete(viewer, offset, compilationUnit);
        TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
        IJavaCompletionProposal[] keyWordResults = collector.getKeywordCompletionProposals();
        int i = 0;
        while (i < keyWordResults.length) {
            String keyword = keyWordResults[i].getDisplayString();
            int k = 0;
            while (k < templateResults.length) {
                TemplateProposal curr = templateResults[k];
                if (keyword.equals(curr.getTemplate().getName())) {
                    curr.setRelevance(keyWordResults[i].getRelevance());
                }
                ++k;
            }
            ++i;
        }
        ICompletionProposal[] total = new ICompletionProposal[results.length + templateResults.length];
        System.arraycopy(templateResults, 0, total, 0, templateResults.length);
        System.arraycopy(results, 0, total, templateResults.length, results.length);
        results = total;
        return results;
    }

    private ICompilationUnit findCompilationUnit(ByteArrayOutputStream arrayOutputStream, JETSkeleton skeleton, IPackageFragmentRoot[] roots) throws JavaModelException {
        ICompilationUnit compilationUnit = null;
        int i = 0;
        while (i < roots.length) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot fragmentRoot = roots[i];
            if (fragmentRoot.getKind() == 1 && (packageFragment = fragmentRoot.getPackageFragment(skeleton.getPackageName())) != null && packageFragment.exists()) {
                compilationUnit = packageFragment.createCompilationUnit(String.valueOf(skeleton.getClassName()) + ".java", arrayOutputStream.toString(), true, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            ++i;
        }
        return compilationUnit;
    }

    private void computeJavaSourceContainer() throws JavaModelException {
        IPackageFragmentRoot[] fragmentRoots = this.javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < fragmentRoots.length) {
            IPackageFragmentRoot fragmentRoot = fragmentRoots[i];
            if (fragmentRoot.getKind() == 1) {
                this.jetNature.setJavaSourceContainer((IContainer)fragmentRoot.getCorrespondingResource());
                break;
            }
            ++i;
        }
    }

    private ICompletionProposal[] order(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

