/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor.presentation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.jet.editor.JETEditorPlugin;
import org.eclipse.emf.codegen.jet.editor.presentation.JETJavaPreviewViewer;
import org.eclipse.emf.codegen.jet.editor.presentation.JETTextEditor;
import org.eclipse.emf.codegen.jet.editor.presentation.JETTextPreviewViewer;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class JETEditor
extends FormEditor
implements ITextEditorExtension,
IMenuListener,
IGotoMarker {
    public static final String ID = "org.eclipse.emf.codegen.jet.editor";
    public static final String copyright = "(c) 2005 Joel Cheuoua & Contributors";
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected JETTextEditor jetTextEditor = new JETTextEditor();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public JETTextEditor getJetTextEditor() {
        return this.jetTextEditor;
    }

    public void addPages() {
        try {
            int pageIndex = this.addPage((IEditorPart)this.jetTextEditor, this.getEditorInput());
            this.setPageText(pageIndex, JETEditorPlugin.getDefault().getString("_UI_JETTemplateEdition_title"));
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Viewer viewer = null;
                IFileEditorInput fileEditorInput = (IFileEditorInput)JETEditor.this.getEditorInput();
                IFile file = fileEditorInput.getFile();
                viewer = file.getFileExtension().equals("javajet") ? new JETJavaPreviewViewer(composite) : new JETTextPreviewViewer(composite);
                return viewer;
            }
        };
        viewerPane.createControl(this.getContainer());
        viewerPane.getViewer().setInput((Object)this.getEditorInput());
        int pageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex, JETEditorPlugin.getDefault().getString("_UI_JETTemplatePreview_title"));
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    JETEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.getContentOutlinePage();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz2)) {
            return this.getPropertySheetPage();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz3)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        return this.propertySheetPage;
    }

    public boolean isDirty() {
        return this.jetTextEditor != null && this.jetTextEditor.isDirty();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.doSave(progressMonitor);
        }
    }

    public boolean isSaveAsAllowed() {
        if (this.jetTextEditor != null) {
            return this.jetTextEditor.isSaveAsAllowed();
        }
        return true;
    }

    public void doSaveAs() {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.doSaveAs();
        }
    }

    public void gotoMarker(IMarker marker) {
        if (this.jetTextEditor != null) {
            IGotoMarker gotoMarker;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((gotoMarker = (IGotoMarker)this.jetTextEditor.getAdapter(clazz)) != null) {
                gotoMarker.gotoMarker(marker);
            }
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.jetTextEditor.init(site, editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public void dispose() {
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void setStatusField(IStatusField field, String category) {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.setStatusField(field, category);
        }
    }

    public boolean isEditorInputReadOnly() {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.isEditorInputReadOnly();
        }
        return false;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.addRulerContextMenuListener(listener);
        }
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        if (this.jetTextEditor != null) {
            this.jetTextEditor.removeRulerContextMenuListener(listener);
        }
    }
}

