/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor.presentation;

import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelItemProviderAdapterFactory;
import org.eclipse.emf.codegen.jet.editor.JETEditorGenerator;
import org.eclipse.emf.codegen.jet.editor.JETURLClassLoader;
import org.eclipse.emf.codegen.jet.editor.JavaClassLoaderFactory;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class JETJavaPreviewViewer
extends Viewer {
    private SourceViewer sourceViewer;
    private Object fInput;
    private ScrolledForm sForm;
    private Text inputResource = null;
    private Button browseWorkspace = null;
    private Tree tree = null;
    private TreeViewer treeViewer = null;
    private ISelection selection;

    public JETJavaPreviewViewer(Composite parent) {
        Display display = parent.getDisplay();
        FormToolkit formToolkit = new FormToolkit(display);
        this.sForm = formToolkit.createScrolledForm(parent);
        ManagedForm overviewForm = new ManagedForm(formToolkit, this.sForm);
        Composite body = this.sForm.getBody();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        body.setLayout((Layout)layout);
        this.createInputArgumentsSection(overviewForm, body, formToolkit);
        this.createJavaTextViewerSection(overviewForm, body, formToolkit);
        overviewForm.initialize();
        overviewForm.refresh();
    }

    private void createInputArgumentsSection(ManagedForm mForm, Composite body, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(body, 256);
        section.setText("Input Argument");
        Composite client = formToolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginWidth = formToolkit.getBorderStyle() != 0 ? 0 : 2;
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        this.inputResource = formToolkit.createText(client, "<Empty>");
        this.inputResource.setEditable(false);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = false;
        this.inputResource.setLayoutData((Object)gd);
        this.browseWorkspace = formToolkit.createButton(client, "Browse...", 0);
        this.browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ResourceSelectionDialog resSelectionDialog = new ResourceSelectionDialog(section.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Select a workspace resource");
                if (resSelectionDialog.open() == 0 && (result = resSelectionDialog.getResult()).length == 1) {
                    String inputFile = ((IResource)result[0]).getFullPath().toString();
                    JETJavaPreviewViewer.this.inputResource.setText(inputFile);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    URI uri = URI.createPlatformResourceURI((String)inputFile);
                    Resource resource = resourceSet.getResource(uri, true);
                    if (resource != null) {
                        JETJavaPreviewViewer.this.treeViewer.setInput((Object)resourceSet);
                    }
                }
            }
        });
        this.tree = formToolkit.createTree(client, 2052);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.tree.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(this.tree);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new GenModelItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        Button button = formToolkit.createButton(client, "Apply", 0x800008);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFileEditorInput fileInput = (IFileEditorInput)JETJavaPreviewViewer.this.fInput;
                IJavaProject javaProject = JavaCore.create((IProject)fileInput.getFile().getProject());
                JETEditorGenerator jetGenerator = new JETEditorGenerator();
                Object generatedObject = null;
                JETJavaPreviewViewer.this.sourceViewer.setInput(null);
                TreeItem[] selection = JETJavaPreviewViewer.this.tree.getSelection();
                if (selection.length == 1) {
                    generatedObject = selection[0].getData();
                }
                if (generatedObject != null) {
                    ClassLoader objectClassLoader = generatedObject.getClass().getClassLoader();
                    URLClassLoader classLoader = JavaClassLoaderFactory.getClassLoader(javaProject, null);
                    ClassLoader currentClassLoader = ((Object)((Object)jetGenerator)).getClass().getClassLoader();
                    ((JETURLClassLoader)classLoader).addClassLoaderDelegate(objectClassLoader);
                    ((JETURLClassLoader)classLoader).addClassLoaderDelegate(currentClassLoader);
                    jetGenerator.setClassLoader(classLoader);
                    String string = jetGenerator.generateJava(generatedObject, fileInput.getFile().getLocation().toString(), (IProgressMonitor)new NullProgressMonitor());
                    if (string != null) {
                        Document document = new Document(string);
                        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document);
                        JETJavaPreviewViewer.this.sourceViewer.setInput((Object)document);
                    } else {
                        Document document = new Document("/** Cannot generate preview with the given input ... Consult the logfile for details.*/");
                        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document);
                        JETJavaPreviewViewer.this.sourceViewer.setInput((Object)document);
                    }
                } else {
                    Document document = new Document("/** Cannot generate preview ... no input was provided.*/");
                    JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document);
                    JETJavaPreviewViewer.this.sourceViewer.setInput((Object)document);
                }
            }
        });
        section.setClient((Control)client);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        section.setLayoutData((Object)gd);
        SectionPart sectionPart = new SectionPart(section);
        mForm.addPart((IFormPart)sectionPart);
    }

    private void createJavaTextViewerSection(ManagedForm mForm, Composite body, FormToolkit formToolkit) {
        Section section = formToolkit.createSection(body, 256);
        section.setText("Preview");
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.sourceViewer = new JavaSourceViewer((Composite)section, null, null, false, 768, store);
        this.sourceViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, null));
        this.sourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        this.sourceViewer.setEditable(false);
        section.setClient(this.sourceViewer.getControl());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        SectionPart sectionPart = new SectionPart(section);
        mForm.addPart((IFormPart)sectionPart);
    }

    public Control getControl() {
        return this.sForm;
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection s, boolean reveal) {
        this.selection = s;
    }

    public void refresh() {
    }
}

