/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor.presentation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.jet.JETSkeleton;
import org.eclipse.emf.codegen.jet.editor.JETEditorPlugin;
import org.eclipse.emf.codegen.jet.editor.dyncheck.JETAnnotationModel;
import org.eclipse.emf.codegen.jet.editor.dyncheck.JETProblemAnnotation;
import org.eclipse.emf.codegen.jet.editor.presentation.JETTextEditor;
import org.eclipse.emf.codegen.jet.editor.util.JETCompilerExt;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class JETReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IProblemRequestor {
    private JETTextEditor jetEditor;
    private ISourceViewer sourceViewer;
    private IDocument currentDocument;
    private IFile jetFile;
    private JETCompilerExt jetCompiler;
    private ICompilationUnit compilationUnit;
    private HashSet problems;

    public JETReconcilingStrategy(ISourceViewer sourceViewer, JETTextEditor jetEditor) {
        this.jetEditor = jetEditor;
        this.sourceViewer = sourceViewer;
    }

    public void setDocument(IDocument document) {
        this.currentDocument = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile();
    }

    public void reconcile(IRegion partition) {
        this.reconcile();
    }

    private void reconcile() {
        IEditorInput editorInput = this.jetEditor.getEditorInput();
        if (editorInput != null) {
            this.jetFile = ((IFileEditorInput)editorInput).getFile();
            IProject project = this.jetFile.getProject();
            try {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                JETNature jetNature = JETNature.getRuntime((IProject)project);
                if (javaProject == null || jetNature == null) {
                    return;
                }
                IContainer parent = this.jetFile.getParent();
                while (parent != null && !jetNature.getTemplateContainers().contains(parent)) {
                    parent = parent.getParent();
                }
                if (parent == null) {
                    jetNature.getTemplateContainers().add(this.jetFile.getParent());
                    jetNature.setTemplateContainers(jetNature.getTemplateContainers());
                }
                if (jetNature.getJavaSourceContainer() == null) {
                    this.computeJavaSourceContainer(jetNature, javaProject);
                }
                String uri = this.jetFile.getLocation().toFile().getAbsoluteFile().toURL().toString();
                String jetSource = this.currentDocument.get();
                ByteArrayInputStream is = new ByteArrayInputStream(jetSource.getBytes());
                this.jetCompiler = new JETCompilerExt(uri, is);
                this.jetCompiler.parse();
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                this.jetCompiler.generate(arrayOutputStream);
                JETSkeleton skeleton = this.jetCompiler.getSkeleton();
                this.computeCompilationUnit(javaProject, arrayOutputStream, skeleton);
                if (this.compilationUnit == null) {
                    return;
                }
                WorkingCopyOwner owner = new WorkingCopyOwner(){};
                ICompilationUnit copy = this.compilationUnit.getWorkingCopy(owner, (IProblemRequestor)this, null);
                JETAnnotationModel annotationModel = (JETAnnotationModel)this.sourceViewer.getAnnotationModel();
                if (annotationModel != null) {
                    annotationModel.setFireChanges(false);
                    Iterator it = annotationModel.getAnnotationIterator();
                    while (it.hasNext()) {
                        Annotation annotation = (Annotation)it.next();
                        if (!(annotation instanceof JETProblemAnnotation)) continue;
                        annotationModel.removeAnnotation(annotation);
                    }
                    copy.reconcile(0, true, owner, null);
                    annotationModel.setFireChanges(true);
                    annotationModel.fireAnnotationModelChanged();
                }
            }
            catch (CoreException e) {
                JETEditorPlugin.getDefault().log((Object)e);
            }
            catch (MalformedURLException e) {
                JETEditorPlugin.getDefault().log(e);
            }
            catch (JETException e) {
                JETEditorPlugin.getDefault().log((Object)e);
            }
        }
    }

    private void computeCompilationUnit(IJavaProject javaProject, ByteArrayOutputStream arrayOutputStream, JETSkeleton skeleton) throws JavaModelException {
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            IPackageFragment packageFragment = root.getPackageFragment(skeleton.getPackageName());
            if (packageFragment != null && packageFragment.exists()) {
                this.compilationUnit = packageFragment.createCompilationUnit(String.valueOf(skeleton.getClassName()) + ".java", arrayOutputStream.toString(), true, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            ++i;
        }
    }

    private void computeJavaSourceContainer(JETNature jetNature, IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] fragmentRoots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < fragmentRoots.length) {
            IPackageFragmentRoot fragmentRoot = fragmentRoots[i];
            if (fragmentRoot.getKind() == 1) {
                jetNature.setJavaSourceContainer((IContainer)fragmentRoot.getCorrespondingResource());
                break;
            }
            ++i;
        }
    }

    public void acceptProblem(IProblem problem) {
        this.problems.add(problem);
    }

    public void beginReporting() {
        if (this.problems == null) {
            this.problems = new HashSet();
        }
        this.problems.clear();
    }

    public void endReporting() {
        Iterator iter = this.problems.iterator();
        while (iter.hasNext()) {
            IProblem problem = (IProblem)iter.next();
            IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
            try {
                int offset = problem.getSourceStart();
                int length = problem.getSourceEnd() - problem.getSourceStart() + 1;
                JETCompilerExt.Range javaRange = this.jetCompiler.getJavaRange(offset);
                JETCompilerExt.Range jetRange = javaRange == null ? null : this.jetCompiler.getJetRange(javaRange);
                int jetOffset = jetRange == null ? 0 : jetRange.start + (offset - javaRange.start);
                JETProblemAnnotation annotation = new JETProblemAnnotation(problem, this.compilationUnit);
                Position position = new Position(jetOffset, length);
                annotationModel.addAnnotation((Annotation)annotation, position);
            }
            catch (Exception e) {
                JETEditorPlugin.getDefault().log(e);
            }
        }
    }

    public boolean isActive() {
        return true;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.reconcile();
    }
}

