/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.jet.editor.JETEditorPlugin;
import org.eclipse.emf.codegen.jet.editor.JETUIMessages;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class NewJETFileCreationWizardPage
extends WizardPage {
    private IContainer container;
    private Label label;
    private GridData gridData;
    protected Text nameText;
    protected Text classText;
    protected Text locationText;
    protected Text packageText;
    protected Button locationButton;
    private IStatus rootStatus;

    protected NewJETFileCreationWizardPage(IContainer container) {
        super("NewJETFileCreationWizardPage");
        this.container = container;
        this.rootStatus = new StatusInfo(4, null);
        this.setTitle(JETUIMessages.NewJETFileCreationWizardPage_title);
        this.setDescription(JETUIMessages.NewJETFileCreationWizardPage_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        this.createNameComposite(container);
        this.createPackageComposite(container);
        this.createClassComposite(container);
        this.createLocationComposite(container);
        this.setControl((Control)container);
        this.setMessage(null);
        this.validatePage();
        Dialog.applyDialogFont((Control)container);
    }

    protected void createNameComposite(Composite container) {
        this.label = new Label(container, 0);
        this.label.setText(JETUIMessages.NewJETFileCreationWizardPage_name_label_text);
        this.nameText = new Text(container, 2052);
        this.gridData = new GridData(768);
        this.gridData.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)this.gridData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJETFileCreationWizardPage.this.validateName();
                NewJETFileCreationWizardPage.this.validatePage();
            }
        });
    }

    protected void createPackageComposite(Composite container) {
        this.label = new Label(container, 0);
        this.label.setText(JETUIMessages.NewJETFileCreationWizardPage_package_label_text);
        this.packageText = new Text(container, 2052);
        this.gridData = new GridData(768);
        this.gridData.horizontalSpan = 2;
        this.packageText.setLayoutData((Object)this.gridData);
        this.packageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJETFileCreationWizardPage.this.validatePackage();
                NewJETFileCreationWizardPage.this.validatePage();
            }
        });
    }

    protected void createClassComposite(Composite container) {
        this.label = new Label(container, 0);
        this.label.setText(JETUIMessages.NewJETFileCreationWizardPage_ClassLabel);
        this.classText = new Text(container, 2052);
        this.gridData = new GridData(768);
        this.gridData.horizontalSpan = 2;
        this.classText.setLayoutData((Object)this.gridData);
        this.classText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJETFileCreationWizardPage.this.validateClass();
                NewJETFileCreationWizardPage.this.validatePage();
            }
        });
    }

    protected void createLocationComposite(Composite container) {
        this.label = new Label(container, 0);
        this.label.setText(JETUIMessages.NewJETFileCreationWizardPage_location_label_text);
        this.locationText = new Text(container, 2052);
        this.gridData = new GridData(768);
        this.gridData.widthHint = 150;
        this.gridData.grabExcessHorizontalSpace = true;
        this.locationText.setEditable(false);
        this.locationText.setLayoutData((Object)this.gridData);
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJETFileCreationWizardPage.this.validateLocation();
                NewJETFileCreationWizardPage.this.validatePage();
            }
        });
        this.locationButton = new Button(container, 8);
        this.gridData = new GridData(128);
        this.gridData.widthHint = 50;
        this.locationButton.setLayoutData((Object)this.gridData);
        this.locationButton.setText(JETUIMessages.NewJETFileCreationWizardPage_location_button_text);
        this.locationButton.setToolTipText(JETUIMessages.NewJETFileCreationWizardPage_location_button_toolTip);
        this.locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJETFileCreationWizardPage.this.handleFileLocation();
            }
        });
        SWTUtil.setButtonDimensionHint((Button)this.locationButton);
    }

    protected void handleFileLocation() {
        Object[] elements;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(JETUIMessages.NewJETFileCreationWizardPage_location_dialog_title);
        dialog.setMessage(JETUIMessages.NewJETFileCreationWizardPage_location_dialog_description);
        dialog.setStatusLineAboveButtons(true);
        dialog.setEmptyListMessage(JETUIMessages.NewJETFileCreationWizardPage_emptyListMessage);
        dialog.setDoubleClickSelects(false);
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                JETNature nature;
                if (element instanceof IProject && (nature = JETNature.getRuntime((IProject)((IProject)element))) != null) {
                    return true;
                }
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    JETNature nature2 = JETNature.getRuntime((IProject)folder.getProject());
                    List templateContainers = nature2.getTemplateContainers();
                    IFolder container = folder;
                    while (container != null) {
                        if (templateContainers.contains(container)) {
                            return true;
                        }
                        container = container.getParent();
                    }
                }
                return false;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                StatusInfo statusInfo = new StatusInfo();
                if (selection.length > 0 && selection[0] instanceof IFolder) {
                    statusInfo.setOK();
                    return statusInfo;
                }
                statusInfo.setError(JETUIMessages.NewJETFileCreationWizardPage_invalidTemplateContainer);
                return statusInfo;
            }
        });
        dialog.setInitialSelection((Object)this.container);
        if (dialog.open() == 0 && (elements = dialog.getResult()).length > 0) {
            IResource elem = (IResource)elements[0];
            String newPath = this.getWorkspaceRelativePath(elem.getLocation().toString());
            this.locationText.setText(String.valueOf(newPath) + "/");
        }
    }

    private String getWorkspaceRelativePath(String path) {
        String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        if (path.startsWith(workspacePath)) {
            path = path.replaceFirst(workspacePath, "");
        }
        return path;
    }

    private void validatePage() {
        this.setPageComplete(this.rootStatus.isOK() && this.nameText.getText().length() > 0 && this.classText.getText().length() > 0 && this.packageText.getText().length() > 0 && this.locationText.getText().length() > 0);
    }

    private void validateLocation() {
        StatusInfo status = new StatusInfo();
        if (this.locationText.getText().length() == 0) {
            status.setError(JETUIMessages.NewJETFileCreationWizardPage_invalidFileName);
        }
        this.updateStatus((IStatus)status);
    }

    private void validatePackage() {
        StatusInfo status = new StatusInfo();
        String packName = this.packageText.getText();
        if (packName.length() > 0) {
            IStatus val = JavaConventions.validatePackageName((String)packName);
            if (val.getSeverity() == 4) {
                status.setError(Messages.format((String)NewWizardMessages.NewPackageWizardPage_error_InvalidPackageName, (Object)val.getMessage()));
            } else if (val.getSeverity() == 2) {
                status.setWarning(Messages.format((String)NewWizardMessages.NewPackageWizardPage_warning_DiscouragedPackageName, (Object)val.getMessage()));
            }
        } else {
            status.setError(NewWizardMessages.NewPackageWizardPage_error_EnterName);
        }
        this.updateStatus((IStatus)status);
    }

    private void validateName() {
        StatusInfo status = new StatusInfo();
        if (this.nameText.getText().length() == 0) {
            status.setError(JETUIMessages.NewJETFileCreationWizardPage_invalidFileName);
        }
        this.updateStatus((IStatus)status);
    }

    private void validateClass() {
        IStatus val;
        StatusInfo status = new StatusInfo();
        String typeName = this.classText.getText();
        if (typeName.length() == 0) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_EnterTypeName);
        }
        if (typeName.indexOf(46) != -1) {
            status.setError(NewWizardMessages.NewTypeWizardPage_error_QualifiedName);
        }
        if ((val = JavaConventions.validateJavaTypeName((String)typeName)).getSeverity() == 4) {
            status.setError(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidTypeName, (Object)val.getMessage()));
        } else if (val.getSeverity() == 2) {
            status.setWarning(Messages.format((String)NewWizardMessages.NewTypeWizardPage_warning_TypeNameDiscouraged, (Object)val.getMessage()));
        }
        this.updateStatus((IStatus)status);
    }

    private InputStream createJETStream() {
        StringWriter stringWriter = new StringWriter();
        String packageString = "package=\"" + this.packageText.getText() + "\" ";
        String classString = "class=\"" + this.classText.getText() + "\" ";
        stringWriter.write("<%@ jet " + packageString + classString + "%>");
        try {
            return new ByteArrayInputStream(stringWriter.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            JETEditorPlugin.getDefault().log(e);
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    public boolean finish() {
        IRunnableWithProgress operation = this.getOperation();
        try {
            this.getContainer().run(false, true, operation);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private IRunnableWithProgress getOperation() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                String filePath = NewJETFileCreationWizardPage.this.locationText.getText().concat(NewJETFileCreationWizardPage.this.nameText.getText());
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
                try {
                    file.create(NewJETFileCreationWizardPage.this.createJETStream(), true, monitor);
                }
                catch (CoreException e) {
                    JETEditorPlugin.getDefault().log((Object)e);
                }
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.emf.codegen.jet.editor");
                }
                catch (PartInitException e) {
                    JETEditorPlugin.getDefault().log((Object)e);
                }
            }
        };
        return operation;
    }

    private void updateStatus(IStatus status) {
        int type = 0;
        if (status.matches(2)) {
            type = 2;
        }
        if (status.matches(4)) {
            type = 3;
        }
        this.setMessage(status.getMessage(), type);
        this.rootStatus = status;
    }
}

