/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.fc.doc.gen;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.ui.activator.AbstractUIActivator;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.fc.doc.gen.internal.plugin.command.SetTocExtensionCommand;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommandRunner;
import org.osgi.framework.BundleContext;

public class FcDocGeneratorActivator
extends AbstractUIActivator {
    private static FcDocGeneratorActivator __plugin;

    public void start(BundleContext context_p) throws Exception {
        super.start(context_p);
        __plugin = this;
    }

    public void stop(BundleContext context_p) throws Exception {
        __plugin = null;
        super.stop(context_p);
    }

    public static FcDocGeneratorActivator getDefault() {
        return __plugin;
    }

    public boolean generateDocumentation(FactoryComponent factoryComponent_p) {
        boolean result = false;
        if (factoryComponent_p == null) {
            return result;
        }
        String updatedFactoryComponentId = factoryComponent_p.getId();
        FactoryComponent instantiatedFcDocGenerator = this.instantiateFcDocGenerator(updatedFactoryComponentId);
        result = CoreActivator.getDefault().generateFactoryComponentSynchronously(instantiatedFcDocGenerator);
        EgfPdeActivator pdeActivator = EgfPdeActivator.getDefault();
        IProject project = pdeActivator.getProjectForFactoryComponent(updatedFactoryComponentId);
        pdeActivator.addEntryInBinaryBuild(project, "tocFC.xml");
        pdeActivator.addEntryInBinaryBuild(project, "html/");
        this.updatePluginFile(updatedFactoryComponentId);
        ProjectHelper.refreshProject((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    private void updatePluginFile(String factoryComponentId_p) {
        IPluginChangesCommandRunner runner = EgfPdeActivator.getDefault().getPluginChangesCommandRunner();
        String pluginId = EgfPdeActivator.getDefault().getPluginIdForFactoryComponent(factoryComponentId_p);
        ArrayList<SetTocExtensionCommand> commands = new ArrayList<SetTocExtensionCommand>(1);
        commands.add(new SetTocExtensionCommand("tocFC.xml"));
        runner.performChangesOnPlugin(pluginId, commands);
    }

    private FactoryComponent instantiateFcDocGenerator(String updatedFactoryComponentId_p) {
        FactoryComponent fc = ModelHelper.createEmptyMinimalFC((String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + "FC Doc Generator Runner"));
        FactoryComponentInvocation fcInvocation = ModelHelper.addFactoryComponentInvocation((FactoryComponent)fc, (String)"asset.1212569371570.34");
        Context context = ModelFactory.eINSTANCE.createContext();
        fcInvocation.setContext(context);
        String pluginId = this.getPluginID();
        ModelHelper.addReferencingContractContextElement((Context)context, (String)fcInvocation.getFactoryComponentId(), (String)"contractElement.1212594422519.34", (String)updatedFactoryComponentId_p, (String)pluginId);
        return fc;
    }
}

