/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.ui.template;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egf.common.helper.IDGeneratorHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.core.extensionpoint.IContractConstants;
import org.eclipse.egf.core.extensionpoint.IFactoryComponentConstants;
import org.eclipse.egf.core.extensionpoint.IProductionPlanConstants;
import org.eclipse.egf.pde.internal.FactoryComponentGeneratorHelper;
import org.eclipse.egf.pde.internal.ui.IHelpContextIds;
import org.eclipse.egf.pde.ui.template.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.templates.PDETemplateSection;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.PluginReference;
import org.eclipse.pde.ui.templates.TemplateOption;

public class EmptyFactoryComponentTemplate
extends PDETemplateSection {
    private static final String FACTORY_COMPONENT_NAME_OPTION_ID = "fcName";
    private TemplateOption _fcNameOption;

    public EmptyFactoryComponentTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, IHelpContextIds.NEW_FACTORY_COMPONENT_TEMPLATE_EMPTY_WIZARD_PAGE);
        page.setTitle(Messages.EmptyFactoryComponentTemplate_Title);
        page.setDescription(Messages.EmptyFactoryComponentTemplate_Description);
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public void init(IFieldData fieldData_p) {
        this._fcNameOption.setValue((Object)fieldData_p.getId());
    }

    private void createOptions() {
        this._fcNameOption = this.addOption(FACTORY_COMPONENT_NAME_OPTION_ID, Messages.EmptyFactoryComponentTemplate_FactoryComponent_Title, "", 0);
    }

    public String getSectionId() {
        return "emptyFactoryComponentSectionId";
    }

    protected void updateModel(IProgressMonitor monitor_p) throws CoreException {
        String contractId = IDGeneratorHelper.generatePrefixUID((String)"contract");
        String productionPlanId = IDGeneratorHelper.generatePrefixUID((String)"productionPlan");
        this.createFactoryComponentExtension(contractId, productionPlanId);
        this.createContractExtension(contractId);
        this.createProductionPlanExtension(productionPlanId);
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        String[] standardDependencies = FactoryComponentGeneratorHelper.getStandardDependencies();
        IPluginReference[] dep = new IPluginReference[]{new PluginReference(standardDependencies[0], null, 0), new PluginReference(standardDependencies[1], null, 0)};
        return dep;
    }

    protected void generateFiles(IProgressMonitor monitor_p) throws CoreException {
        super.generateFiles(monitor_p);
        FactoryComponentGeneratorHelper.createGeneratedSourceFolder(this.project);
        ProjectHelper.createFolder((String)"templates", (IProject)this.project, (IProgressMonitor)new SubProgressMonitor(monitor_p, 1));
        ProjectHelper.createFolder((String)"model", (IProject)this.project, (IProgressMonitor)new SubProgressMonitor(monitor_p, 1));
    }

    public String[] getNewFiles() {
        return new String[]{"model/", "templates/"};
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    public String getUsedExtensionPoint() {
        return null;
    }

    protected void createProductionPlanExtension(String productionPlanId_p) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension(IProductionPlanConstants.FULLY_QUALIFIED_EXTENSION_POINT_ID, true);
        IPluginElement element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("productionPlan");
        element.setAttribute("id", productionPlanId_p);
        extension.add((IPluginObject)element);
        this.addExtensionInModel(plugin, extension);
    }

    protected void createContractExtension(String contractId_p) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension(IContractConstants.FULLY_QUALIFIED_EXTENSION_POINT_ID, true);
        IPluginElement element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("contract");
        element.setAttribute("id", contractId_p);
        extension.add((IPluginObject)element);
        this.addExtensionInModel(plugin, extension);
    }

    protected void createFactoryComponentExtension(String contractId_p, String productionPlanId_p) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension(IFactoryComponentConstants.FULLY_QUALIFIED_EXTENSION_POINT_ID, true);
        IPluginElement element = this.model.getPluginFactory().createElement((IPluginObject)extension);
        element.setName("factoryComponent");
        String fcNameEnteredByEndUser = this.getStringOption(FACTORY_COMPONENT_NAME_OPTION_ID);
        element.setAttribute("id", IDGeneratorHelper.generatePrefixUID((String)"factoryComponent"));
        element.setAttribute("name", fcNameEnteredByEndUser);
        element.setAttribute("contractId", contractId_p);
        element.setAttribute("productionPlanId", productionPlanId_p);
        extension.add((IPluginObject)element);
        this.addExtensionInModel(plugin, extension);
    }

    protected void addExtensionInModel(IPluginBase plugin_p, IPluginExtension extension_p) throws CoreException {
        if (!extension_p.isInTheModel()) {
            plugin_p.add(extension_p);
        }
    }
}

