/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.data.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.helper.PatternHelper;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.AbstractViewpoint;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.Contract;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.Domain;
import org.eclipse.egf.model.Factory;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.MappingModel;
import org.eclipse.egf.model.MappingViewpoint;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.PatternViewpoint;
import org.eclipse.egf.model.ProductionPlan;
import org.eclipse.egf.model.Specification;
import org.eclipse.egf.model.Type;
import org.eclipse.egf.model.ViewpointType;
import org.eclipse.egf.model.internal.data.ModelElement;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelHelper {
    public static FactoryComponent getFactoryComponentContainer(NamedModelElementWithId modelElement_p) {
        FactoryComponent result = modelElement_p instanceof FactoryComponent ? (FactoryComponent)modelElement_p : null;
        boolean isSearching = true;
        while (isSearching && result == null) {
            NamedModelElementWithId parent = (NamedModelElementWithId)modelElement_p.eContainer();
            if (parent instanceof FactoryComponent) {
                result = (FactoryComponent)parent;
                continue;
            }
            if (parent == null) {
                isSearching = false;
                continue;
            }
            result = ModelHelper.getFactoryComponentContainer(parent);
        }
        return result;
    }

    public static FactoryComponent getFactoryComponentFrom(String factoryComponentName_p, Collection<FactoryComponent> factoryComponents_p) {
        FactoryComponent result = null;
        Iterator<FactoryComponent> fcs = factoryComponents_p.iterator();
        while (fcs.hasNext() && result == null) {
            FactoryComponent currentFc = fcs.next();
            if (!factoryComponentName_p.equals(currentFc.getName())) continue;
            result = currentFc;
        }
        return result;
    }

    public static void addViewpointTypeId(String patternViewpointId_p, ViewpointType viewpointType_p, FactoryComponent factoryComponent_p) {
        Specification specification = ModelHelper.getSpecification(factoryComponent_p);
        EList<String> viewpointIds = ModelHelper.getViewpointTypeIds(specification, viewpointType_p);
        viewpointIds.add((Object)patternViewpointId_p);
    }

    private static Specification getSpecification(FactoryComponent factoryComponent_p) {
        Specification specification = factoryComponent_p.getSpecification();
        if (specification == null) {
            specification = ModelFactory.eINSTANCE.createSpecification();
            factoryComponent_p.setSpecification(specification);
            specification.setViewpointIds(new HashMap<ViewpointType, EList<String>>(0));
        }
        return specification;
    }

    public static EList<String> getViewpointTypeIds(Specification specification_p, ViewpointType viewpointType_p) {
        Map<ViewpointType, EList<String>> viewpointIds = specification_p.getViewpointIds();
        BasicEList viewpointTypeIds = viewpointIds.get((Object)viewpointType_p);
        if (viewpointTypeIds == null) {
            viewpointTypeIds = new BasicEList(0);
            viewpointIds.put(viewpointType_p, (EList<String>)viewpointTypeIds);
        }
        return viewpointTypeIds;
    }

    public static Contract getContract(FactoryComponent factoryComponent_p) {
        Contract result = (Contract)ModelHelper.getViewpoint(ViewpointType.CONTRACT, factoryComponent_p);
        return result;
    }

    public static List<ContractElement> getMandatoryContractElement(FactoryComponent factoryComponent_p) {
        EList<ContractElement> contractElements;
        ArrayList<ContractElement> result = new ArrayList<ContractElement>(0);
        if (factoryComponent_p == null) {
            return result;
        }
        Contract contract = ModelHelper.getContract(factoryComponent_p);
        if (contract != null && !(contractElements = contract.getContractElements()).isEmpty()) {
            for (ContractElement contractElement : contractElements) {
                if (!contractElement.isMandatory()) continue;
                result.add(contractElement);
            }
        }
        return result;
    }

    public static PatternViewpoint getPatternViewpoint(FactoryComponent factoryComponent_p) {
        PatternViewpoint result = (PatternViewpoint)ModelHelper.getViewpoint(ViewpointType.PATTERN, factoryComponent_p);
        return result;
    }

    private static AbstractViewpoint getViewpoint(ViewpointType viewpointType_p, FactoryComponent factoryComponent_p) {
        Map<ViewpointType, EList<String>> allViewpointIds;
        EList<String> viewpointTypeIds;
        AbstractViewpoint result = null;
        Specification specification = ModelHelper.getSpecification(factoryComponent_p);
        if (specification != null && (viewpointTypeIds = (allViewpointIds = specification.getViewpointIds()).get((Object)viewpointType_p)) != null && !viewpointTypeIds.isEmpty()) {
            String searchedViewpointTypeId = (String)viewpointTypeIds.get(0);
            Iterator viewpoints = specification.getViewpoints().iterator();
            while (viewpoints.hasNext() && result == null) {
                AbstractViewpoint currentViewpoint = (AbstractViewpoint)viewpoints.next();
                if (!searchedViewpointTypeId.equals(currentViewpoint.getId())) continue;
                result = currentViewpoint;
            }
        }
        return result;
    }

    public static ProductionPlan getProductionPlan(FactoryComponent factoryComponent_p) {
        ProductionPlan result = null;
        Factory factory = factoryComponent_p.getFactory();
        if (factory != null) {
            result = factory.getProductionPlan();
        }
        return result;
    }

    public static void setContractType(ContractElement contractElement_p, String typeName_p) {
        if (contractElement_p == null) {
            return;
        }
        Type contractType = contractElement_p.getContractType();
        if (contractType == null) {
            contractType = ModelFactory.eINSTANCE.createType();
            contractElement_p.setContractType(contractType);
        }
        contractType.setTypeHolderClassName(typeName_p);
    }

    public static void setContextType(ContextElement contextElement_p, String typeName_p) {
        if (contextElement_p == null) {
            return;
        }
        Type contextType = contextElement_p.getContextType();
        if (contextType == null) {
            contextType = ModelFactory.eINSTANCE.createType();
            contextElement_p.setContextType(contextType);
        }
        contextType.setTypeHolderClassName(typeName_p);
    }

    public static ContractElementReference createContractElementReferenceBasedOn(ContractElement contractElement_p) {
        ContractElementReference contractElementReference = null;
        if (contractElement_p == null) {
            return contractElementReference;
        }
        contractElementReference = ModelFactory.eINSTANCE.createContractElementReference();
        contractElementReference.setReferencedFactoryComponentId(contractElement_p.getFactoryComponentId());
        contractElementReference.setReferencedContractElementId(contractElement_p.getId());
        contractElementReference.setReferencedContractElement(contractElement_p);
        return contractElementReference;
    }

    public static PatternLibrary getLibrary(String libraryId_p, PatternViewpoint patternViewpoint_p) {
        PatternLibrary result = null;
        Iterator libraries = patternViewpoint_p.getLibraries().iterator();
        while (libraries.hasNext() && result == null) {
            PatternLibrary currentLibrary = (PatternLibrary)libraries.next();
            String currentLibraryId = currentLibrary.getId();
            result = libraryId_p.equals(currentLibraryId) ? currentLibrary : ModelHelper.getLibrary(libraryId_p, currentLibrary);
        }
        return result;
    }

    public static PatternLibrary getLibrary(String libraryId_p, PatternLibrary parentLibrary_p) {
        PatternLibrary result = null;
        Iterator patternElements = parentLibrary_p.getPatternElements().iterator();
        while (patternElements.hasNext() && result == null) {
            AbstractPatternElement currentPatternElement = (AbstractPatternElement)patternElements.next();
            if (!(currentPatternElement instanceof PatternLibrary)) continue;
            PatternLibrary currentLibrary = (PatternLibrary)currentPatternElement;
            result = libraryId_p.equals(currentPatternElement.getId()) ? currentLibrary : ModelHelper.getLibrary(libraryId_p, currentLibrary);
        }
        return result;
    }

    public static String getPatternElementShortId(AbstractPatternElement patternElement_p) {
        Couple<String, String> ids = ModelHelper.getDeresolvedIds(patternElement_p);
        return (String)ids.getValue();
    }

    public static String getParentLibraryId(AbstractPatternElement patternElement_p) {
        Couple<String, String> ids = ModelHelper.getDeresolvedIds(patternElement_p);
        String parentId = (String)ids.getKey();
        if (patternElement_p.getId().equals(parentId)) {
            parentId = null;
        }
        return parentId;
    }

    public static AbstractPatternElement getPatternElement(String shortPatternElementId_p, PatternLibrary parentLibrary_p) {
        AbstractPatternElement result = null;
        Iterator patternElements = parentLibrary_p.getPatternElements().iterator();
        while (patternElements.hasNext() && result == null) {
            AbstractPatternElement currentPatternElement = (AbstractPatternElement)patternElements.next();
            String currentChildShortId = ModelHelper.getPatternElementShortId(currentPatternElement);
            if (!shortPatternElementId_p.equals(currentChildShortId)) continue;
            result = currentPatternElement;
        }
        return result;
    }

    private static Couple<String, String> getDeresolvedIds(AbstractPatternElement patternElement_p) {
        String patternFullId = patternElement_p.getId();
        Couple ids = PatternHelper.deresolveId((String)patternFullId);
        return ids;
    }

    public static boolean isDomainDefined(Domain domain_p) {
        return domain_p != null && domain_p.getPath() != null;
    }

    public static List<MappingModel> getMappings(FactoryComponent factoryComponent_p) {
        MappingViewpoint mappingViewpoint = ModelHelper.getMappingViewpoint(factoryComponent_p);
        return new ArrayList<MappingModel>((Collection<MappingModel>)mappingViewpoint.getMappings());
    }

    public static MappingViewpoint getMappingViewpoint(FactoryComponent factoryComponent_p) {
        return (MappingViewpoint)ModelHelper.getViewpoint(ViewpointType.MAPPING, factoryComponent_p);
    }

    public static FactoryComponent createEmptyMinimalFC(String factoryComponentName_p) {
        FactoryComponent fc = ModelFactory.eINSTANCE.createFactoryComponent();
        fc.setName(factoryComponentName_p);
        Factory factory = ModelFactory.eINSTANCE.createFactory();
        fc.setFactory(factory);
        ProductionPlan productionPlan = ModelFactory.eINSTANCE.createProductionPlan();
        factory.setProductionPlan(productionPlan);
        return fc;
    }

    public static FactoryComponentInvocation addFactoryComponentInvocation(FactoryComponent owningFC_p, String referencedFCId_p) {
        FactoryComponentInvocation result = null;
        if (owningFC_p == null || referencedFCId_p == null) {
            return result;
        }
        ProductionPlan productionPlan = ModelHelper.getProductionPlan(owningFC_p);
        result = ModelFactory.eINSTANCE.createFactoryComponentInvocation();
        productionPlan.getFactoryComponentInvocations().add((Object)result);
        result.setFactoryComponentId(referencedFCId_p);
        return result;
    }

    public static void addReferencingContractContextElement(Context context_p, String referencedFactoryComponentId_p, String referencedContractElementId_p, String value_p, String contributorId_p) {
        ContextElement contextElement = ModelFactory.eINSTANCE.createContextElement();
        context_p.getContextElements().add((Object)contextElement);
        ContractElementReference contractElementRef = ModelFactory.eINSTANCE.createContractElementReference();
        contractElementRef.setReferencedFactoryComponentId(referencedFactoryComponentId_p);
        contractElementRef.setReferencedContractElementId(referencedContractElementId_p);
        contextElement.setContractElementReference(contractElementRef);
        contextElement.setReadableValue(value_p);
        contextElement.setPluginId(contributorId_p);
    }

    public static MappingModel createMappingModel(String mappingRelativePath_p, String sourceFactoryComponentId_p, String targetFactoryComponentId_p, String mappingId_p) {
        MappingModel newModel = null;
        if (mappingRelativePath_p == null) {
            return newModel;
        }
        newModel = ModelFactory.eINSTANCE.createMappingModel();
        newModel.setPath(mappingRelativePath_p);
        newModel.setName(new Path(mappingRelativePath_p).removeFileExtension().lastSegment());
        newModel.setSource(sourceFactoryComponentId_p);
        newModel.setTarget(targetFactoryComponentId_p);
        newModel.setId(mappingId_p);
        return newModel;
    }

    public static MappingModel getMapping(String mappingId_p, List<MappingModel> mappings_p) {
        MappingModel result = null;
        Iterator<MappingModel> iter = mappings_p.iterator();
        while (iter.hasNext() && result == null) {
            MappingModel currentMapping = iter.next();
            if (!mappingId_p.equals(currentMapping.getId())) continue;
            result = currentMapping;
        }
        return result;
    }

    public static IProject getProject(NamedModelElementWithId modelElement_p) {
        IProject project = null;
        FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer(modelElement_p);
        if (fcContainer != null) {
            project = (IProject)((ModelElement)((Object)fcContainer)).getAdapter(IProject.class);
        }
        return project;
    }
}

