/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.util;

import java.beans.PropertyChangeListener;
import java.util.Map;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.pattern.Generator;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.PatternPackage;
import org.eclipse.egf.pattern.util.Messages;
import org.eclipse.egf.pattern.validation.PatternDelegatedValidator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternValidator
extends EObjectValidator {
    public static final PatternValidator INSTANCE = new PatternValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.pattern";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected EcoreValidator ecoreValidator = EcoreValidator.INSTANCE;

    protected EPackage getEPackage() {
        return PatternPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateGenerator((Generator)value, diagnostics, context);
            }
            case 1: {
                return this.validatePattern((Pattern)value, diagnostics, context);
            }
            case 2: {
                return this.validatePPropertyChangeListener((PropertyChangeListener)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateGenerator(Generator generator, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(generator, diagnostics, context);
    }

    public boolean validatePattern(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(pattern, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateENamedElement_WellFormedName((ENamedElement)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClassifier_WellFormedInstanceTypeName((EClassifier)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClassifier_UniqueTypeParameterNames((EClassifier)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_InterfaceIsAbstract((EClass)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_AtMostOneID((EClass)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_UniqueFeatureNames((EClass)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_UniqueOperationSignatures((EClass)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_NoCircularSuperTypes((EClass)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_WellFormedMapEntryClass((EClass)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_ConsistentSuperTypes((EClass)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.ecoreValidator.validateEClass_DisjointFeatureAndOperationSignatures((EClass)pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePattern_overall(pattern, diagnostics, context);
        }
        return result;
    }

    public boolean validatePattern_overall(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        PatternDelegatedValidator validator = new PatternDelegatedValidator(pattern);
        String patternName = pattern.getName();
        if (validator.parentNameCollision()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, StringHelper.formatMessage((String)Messages.PatternValidator_NameCollisionWithParentOne, (Object[])new Object[]{patternName}), new Object[]{pattern}));
            }
            return false;
        }
        return true;
    }

    public boolean validatePPropertyChangeListener(PropertyChangeListener pPropertyChangeListener, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

