/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.refactoring.move;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.pattern.refactoring.internal.move.change.PatternElementChange;
import org.eclipse.egf.pattern.refactoring.move.Messages;
import org.eclipse.egf.pattern.refactoring.move.MoveInfo;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class MoveProcessor
extends RefactoringProcessor {
    private MoveInfo _moveInfo;

    public MoveProcessor(MoveInfo info_p) {
        Assert.isNotNull((Object)info_p);
        this._moveInfo = info_p;
    }

    public Object[] getElements() {
        return this._moveInfo.getElementsToMove().toArray();
    }

    public String getIdentifier() {
        return MoveProcessor.class.getName();
    }

    public String getProcessorName() {
        return MoveProcessor.class.getSimpleName();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm_p, CheckConditionsContext context_p) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        NamedModelElementWithId destinationElement = this._moveInfo.getDestinationElement();
        if (destinationElement == null) {
            result.addFatalError(Messages.MoveProcessor_Conditions_Error_NoDestination);
        }
        if (!this._moveInfo.checkDestinationType()) {
            result.addFatalError(Messages.MoveProcessor_Conditions_Error_InvalidDestination);
        }
        if (!this._moveInfo.isMoveAcceptable()) {
            result.addError(Messages.MoveProcessor_Conditions_Error_ElementsNotMovable);
        }
        this._moveInfo.retainRelevantElementsToMove();
        if (this._moveInfo.getElementsToMove().isEmpty()) {
            result.addError(Messages.MoveProcessor_Conditions_Error_NoElementToMove);
        }
        return result;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm_p) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        boolean noElement = this._moveInfo.getElementsToMove().isEmpty();
        if (noElement) {
            result.addError(Messages.MoveProcessor_Conditions_Error_NoElementToMove);
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm_p) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(this.getProcessorName());
        NamedModelElementWithId destinationLibrary = this._moveInfo.getDestinationElement();
        for (AbstractPatternElement patternElement : this._moveInfo.getElementsToMove()) {
            change.add(PatternElementChange.createPatternElementChange(destinationLibrary, patternElement));
        }
        return change;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status_p, SharableParticipants sharedParticipants_p) throws CoreException {
        return new RefactoringParticipant[0];
    }
}

