/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.egf.pattern.ui.editor.page.IExternalSelectionHandler;
import org.eclipse.egf.pattern.ui.editor.page.IExternalSelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ExternalSelectionManager
implements IExternalSelectionProvider {
    private Map<Class, Collection<IExternalSelectionHandler>> _externalSelectionHandlers;

    public void dispose() {
        if (this._externalSelectionHandlers != null) {
            this._externalSelectionHandlers.clear();
        }
        this._externalSelectionHandlers = null;
    }

    public void addExternalHandlerFor(Class selectedObjectType_p, IExternalSelectionHandler handler_p) {
        Collection<IExternalSelectionHandler> handlers;
        if (selectedObjectType_p == null || handler_p == null) {
            return;
        }
        if (this._externalSelectionHandlers == null) {
            this._externalSelectionHandlers = new HashMap<Class, Collection<IExternalSelectionHandler>>(1);
        }
        if ((handlers = this._externalSelectionHandlers.get(selectedObjectType_p)) == null) {
            handlers = new HashSet<IExternalSelectionHandler>(1);
            this._externalSelectionHandlers.put(selectedObjectType_p, handlers);
        }
        handlers.add(handler_p);
    }

    public void removeHandlersForType(Class type_p) {
        if (type_p == null || this._externalSelectionHandlers == null) {
            return;
        }
        this._externalSelectionHandlers.remove(type_p);
        if (this._externalSelectionHandlers.isEmpty()) {
            this._externalSelectionHandlers = null;
        }
    }

    public void removeExternalHandler(IExternalSelectionHandler handler_p) {
        if (handler_p == null || this._externalSelectionHandlers == null) {
            return;
        }
        ArrayList<Class> typesToRemove = new ArrayList<Class>(0);
        for (Map.Entry<Class, Collection<IExternalSelectionHandler>> entrySet : this._externalSelectionHandlers.entrySet()) {
            Collection<IExternalSelectionHandler> handlersCollection = entrySet.getValue();
            handlersCollection.remove(handler_p);
            if (!handlersCollection.isEmpty()) continue;
            typesToRemove.add(entrySet.getKey());
        }
        for (Class type : typesToRemove) {
            this.removeHandlersForType(type);
        }
    }

    public void removeExternalHandler(IExternalSelectionHandler handler_p, Class type_p) {
        if (handler_p == null || this._externalSelectionHandlers == null) {
            return;
        }
        if (type_p != null) {
            Collection<IExternalSelectionHandler> handlers = this._externalSelectionHandlers.get(type_p);
            if (handlers != null) {
                handlers.remove(handler_p);
                if (handlers.isEmpty()) {
                    this.removeHandlersForType(type_p);
                }
            }
        } else {
            this.removeExternalHandler(handler_p);
        }
    }

    public void fireExternalSelection(Object firstSelectedObject_p, IStructuredSelection selection_p) {
        if (this._externalSelectionHandlers == null || firstSelectedObject_p == null) {
            return;
        }
        for (Map.Entry<Class, Collection<IExternalSelectionHandler>> entrySet : this._externalSelectionHandlers.entrySet()) {
            Class type = entrySet.getKey();
            if (!type.isInstance(firstSelectedObject_p)) continue;
            Collection<IExternalSelectionHandler> handlers = entrySet.getValue();
            for (IExternalSelectionHandler externalSelectionHandler : handlers) {
                externalSelectionHandler.handleSelection(firstSelectedObject_p, selection_p);
            }
        }
    }
}

