/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.internal.editor.page.specification;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.listener.DefaultResourceListener;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.ui.helper.FormHelper;
import org.eclipse.egf.common.ui.helper.WorkbenchHelper;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.production.GeneratedContentProducer;
import org.eclipse.egf.pattern.ui.editor.page.util.DisplayHelper;
import org.eclipse.egf.pattern.ui.internal.editor.page.specification.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ConditionViewer {
    protected static final Logger __logger = Logger.getLogger((String)ConditionViewer.class.getPackage().getName());
    private FormToolkit _toolkit;
    protected PatternHandler.PatternData _patternData;
    private ConditionLinkListener _conditionLinkListener;
    protected PatternHandler _patternHandler;
    protected boolean _isEditable;
    private DefaultResourceListener _listener;

    public ConditionViewer(Composite parent_p, FormToolkit toolkit_p, PatternHandler.PatternData patternData_p, PatternHandler handler_p, boolean isEditable_p) {
        this._isEditable = isEditable_p;
        this._toolkit = toolkit_p;
        this._patternData = patternData_p;
        this._patternHandler = handler_p;
        this.doCreateContent(parent_p);
    }

    public void dispose() {
        if (this._listener != null) {
            this._listener.dispose();
            this._listener = null;
        }
    }

    protected void doCreateContent(Composite parent_p) {
        Composite conditionComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)this._toolkit, (Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)2, (boolean)false);
        Couple editionCouple = FormHelper.createSectionWithChildComposite((FormToolkit)this._toolkit, (Composite)conditionComposite, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)2, (boolean)false);
        Section editionSection = (Section)editionCouple.getKey();
        editionSection.setText(Messages.ConditionViewer_EditSectionTitle);
        Composite editionComposite = (Composite)editionCouple.getValue();
        Image image = JavaPlugin.getDefault().getImageRegistry().get("org.eclipse.jdt.ui.class_obj.gif");
        this._conditionLinkListener = new ConditionLinkListener();
        FormHelper.createLinkWithDescription((FormToolkit)this._toolkit, (Composite)editionComposite, (Image)image, (String)Messages.ConditionViewer_EditSectionLinkLabel, null, (String)Messages.ConditionViewer_EditSectionLinkDescription, (IHyperlinkListener)this._conditionLinkListener);
        editionComposite.setEnabled(this._isEditable);
        Couple previewCouple = FormHelper.createSectionWithChildComposite((FormToolkit)this._toolkit, (Composite)conditionComposite, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
        Section previewSection = (Section)previewCouple.getKey();
        previewSection.setText(Messages.ConditionViewer_HowToSectionTitle);
        Composite previewComposite = (Composite)previewCouple.getValue();
        final String conditionFileRelativePath = GeneratedContentProducer.getConditionFileRelativePath((PatternHandler.PatternData)this._patternData);
        String content = FileHelper.readFile((String)conditionFileRelativePath);
        final Text conditionText = this._toolkit.createText(previewComposite, content, 832);
        if (this._isEditable) {
            final Display display = conditionText.getShell().getDisplay();
            IFile fileResource = FileHelper.getPlatformFile((String)conditionFileRelativePath);
            this._listener = new DefaultResourceListener(){

                protected void handleResourceChanged(IResourceChangeEvent event_p, IResource watchedResource_p) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            conditionText.setText(FileHelper.readFile((String)conditionFileRelativePath));
                        }
                    });
                }
            };
            this._listener.setResourceToWatch((IResource)fileResource);
        }
        conditionText.setEditable(false);
        FormHelper.updateControlLayoutDataWithLayoutTypeData((Control)conditionText, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT);
        FormHelper.forceControlSize((Control)conditionText, (int)DisplayHelper.DEFAULT_TEXT_WIDTH_IN_CHARS, (int)DisplayHelper.DEFAULT_TEXT_HEIGHT_IN_CHARS);
    }

    protected class ConditionLinkListener
    extends HyperlinkAdapter {
        private static final String EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";

        protected ConditionLinkListener() {
        }

        public void linkActivated(HyperlinkEvent e_p) {
            ConditionViewer.this._patternHandler.recomputeConditionStructures();
            String generatedClassRelativePath = GeneratedContentProducer.getConditionFileRelativePath((PatternHandler.PatternData)ConditionViewer.this._patternData);
            WorkbenchHelper.openFileEditor((String)generatedClassRelativePath, (String)EDITOR_ID, (boolean)ConditionViewer.this._isEditable);
        }
    }
}

