/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.internal.validators;

import java.util.Iterator;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.common.ui.toolkit.validators.NotEmptyStringValidator;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.PatternViewpoint;

public class PatternElementValidator
extends NotEmptyStringValidator {
    private NamedModelElementWithId _parent;
    private AbstractPatternElement _pattern;

    public PatternElementValidator(NamedModelElementWithId parent_p, AbstractPatternElement pattern_p, String errorMessage_p) {
        super(errorMessage_p);
        this._parent = parent_p;
        this._pattern = pattern_p;
    }

    public String isValid(Object value_p) {
        String errorMessage = super.isValid(value_p);
        if (errorMessage != null) {
            return errorMessage;
        }
        String name = (String)value_p;
        if (this._parent != null) {
            Iterator siblingElements = null;
            if (this._parent instanceof PatternLibrary) {
                siblingElements = ((PatternLibrary)this._parent).getPatternElements().iterator();
            } else if (this._parent instanceof PatternViewpoint) {
                siblingElements = ((PatternViewpoint)this._parent).getLibraries().iterator();
            }
            if (siblingElements != null) {
                while (siblingElements.hasNext() && errorMessage == null) {
                    AbstractPatternElement currentPattern = (AbstractPatternElement)siblingElements.next();
                    if (this._pattern == currentPattern || this._pattern.getClass() != currentPattern.getClass() || !currentPattern.getName().equals(name)) continue;
                    errorMessage = this.formatErrorMessage(name, Messages.PatternElementValidator_Sibling_EndMessage);
                }
            }
        }
        return errorMessage;
    }

    private String formatErrorMessage(String alreadyUsedName_p, String messageEndPart_p) {
        String errorMessage = Messages.PatternElementValidator_Name_Already_Used_ErrorMessage;
        return MessageFormatHelper.formatMessage((String)errorMessage, (Object[])new String[]{alreadyUsedName_p, messageEndPart_p});
    }
}

