/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import org.apache.log4j.Logger;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.misc.PlatformLocationType;
import org.eclipse.egf.common.ui.helper.DataBindingHelper;
import org.eclipse.egf.common.ui.toolkit.fields.CStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.wizard.page.AbstractWizardPage;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.core.ui.internal.databinding.UpdateWizardPage;
import org.eclipse.egf.core.ui.wizard.AbstractModelElementWizard;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.edit.helper.FactoryComponentHelper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public abstract class AbstractModelElementWizardPage
extends AbstractWizardPage {
    private static final Logger __logger = Logger.getLogger((String)AbstractModelElementWizardPage.class.getPackage().getName());
    private ClassLoader _hostingProjectClassLoader;
    private Bundle _hostingBundle;

    public AbstractModelElementWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public AbstractModelElementWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected NamedModelElementWithId getModelElement() {
        return this.getModelElementWizard().getModelElement();
    }

    protected NamedModelElementWithId getParent() {
        return (NamedModelElementWithId)this.getModelElementWizard().getParent();
    }

    protected AbstractModelElementWizard getModelElementWizard() {
        return (AbstractModelElementWizard)this.getWizard();
    }

    protected boolean isReadOnly() {
        return this.getModelElementWizard().isInReadOnlyMode();
    }

    protected boolean handleFieldEditorValidation(IFieldEditor[] fieldEditors_p) {
        boolean isValid = true;
        if (this.getModelElementWizard().isInReadOnlyMode()) {
            this.setErrorMessage(null);
            return isValid;
        }
        String errorMessage = null;
        int i = 0;
        while (i < fieldEditors_p.length && isValid) {
            IFieldEditor fieldEditor = fieldEditors_p[i];
            isValid = fieldEditor.isValid();
            if (!isValid) {
                errorMessage = fieldEditor.getErrorMessage();
            }
            ++i;
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        }
        return isValid;
    }

    protected String getPageDescription() {
        return ((AbstractModelElementWizard)this.getWizard()).getDescription();
    }

    protected void showErrorMessage(CStringFieldEditor fieldEditor_p, String errorMessage_p) {
        fieldEditor_p.setErrorMessage(errorMessage_p);
        fieldEditor_p.showErrorMessage();
    }

    protected void bindTextToAttribute(Text text_p, EAttribute feature_p, NamedModelElementWithId modelElement_p, UpdateWizardPage featureValueChangeListener_p) {
        this.bindTextToAttribute(text_p, feature_p.getName(), (Object)modelElement_p, featureValueChangeListener_p);
    }

    protected void bindTextToAttribute(Text text_p, String propertyName_p, Object modelElement_p, UpdateWizardPage featureValueChangeListener_p) {
        UpdateWizardPage featureValueChangeListener = featureValueChangeListener_p != null ? featureValueChangeListener_p : new UpdateWizardPage(this);
        DataBindingHelper.bindTextToProperty((Control)text_p, (String)propertyName_p, (Object)modelElement_p, (IValueChangeListener)featureValueChangeListener);
    }

    protected IJavaProject getHostingProject() {
        IJavaProject javaProject = null;
        IProject project = ModelHelper.getProject((NamedModelElementWithId)this.getParent());
        if (project != null) {
            javaProject = ProjectHelper.getJavaProject((String)project.getName());
        }
        return javaProject;
    }

    protected String getHostingPluginId() {
        FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)this.getParent());
        String hostingPluginId = FactoryComponentHelper.getPluginId((String)fcContainer.getId(), (PlatformLocationType)PlatformLocationType.WORKSPACE_ONLY);
        return hostingPluginId;
    }

    protected ClassLoader getHostingProjectClassLoader() {
        if (this._hostingProjectClassLoader == null) {
            IJavaProject javaProject = this.getHostingProject();
            if (javaProject == null) {
                return this._hostingProjectClassLoader;
            }
            try {
                this._hostingProjectClassLoader = ProjectHelper.getClassLoaderFor((IJavaProject)javaProject, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (Exception exception_p) {
                StringBuilder loggerMessage = new StringBuilder("AbstractNamedElementWizardPage.getHostingProjectClassLoader(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
        return this._hostingProjectClassLoader;
    }

    protected Bundle getHostingBundle() {
        if (this._hostingBundle == null) {
            this._hostingBundle = CoreActivator.getDefault().getBundleForFactoryComponent(this.getParent());
        }
        return this._hostingBundle;
    }

    protected AdapterFactory getAdapterFactory() {
        AdapterFactory result = this.getModelElementWizard().isInReadOnlyMode() ? EgfUiActivator.getDefault().getEditingDomainInReadOnly().getAdapterFactory() : EgfUiActivator.getDefault().getEditingDomain().getAdapterFactory();
        return result;
    }
}

