/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import java.util.Collections;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.egf.common.ui.field.ValidatingStringButtonFieldEditor;
import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.ValidatingStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.egf.common.ui.toolkit.validators.NotEmptyStringValidator;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.ui.internal.databinding.ReferencedFactoryComponent;
import org.eclipse.egf.core.ui.internal.databinding.UpdateWizardPage;
import org.eclipse.egf.core.ui.internal.databinding.ValueChangeHandler;
import org.eclipse.egf.core.ui.internal.dialogs.FactoryComponentSelectionDialog;
import org.eclipse.egf.core.ui.internal.field.ModelElementButtonFieldEditor;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.internal.validators.ReferencedFactoryComponentValidator;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FactoryComponentInvocationWizardPage
extends AbstractModelElementWizardPage {
    private ValidatingStringFieldEditor _factoryComponentInvocationNameFieldEditor;
    private ValidatingStringButtonFieldEditor _referencedFactoryComponentFieldEditor;
    protected String _referencedFactoryComponentId;

    public FactoryComponentInvocationWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public FactoryComponentInvocationWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected FactoryComponentInvocation getFactoryComponentInvocation() {
        return (FactoryComponentInvocation)this.getModelElement();
    }

    protected void createPageArea(Composite parent_p) {
        this.createFactoryComponentInvocationNameFieldEditor(parent_p);
        this.createReferencedFactoryComponentFieldEditor(parent_p);
        this.handlePageLayout(parent_p);
    }

    private void createFactoryComponentInvocationNameFieldEditor(Composite parent_p) {
        this._factoryComponentInvocationNameFieldEditor = FieldEditorHelper.createStringFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.FactoryComponentInvocationWizardPage_Name_Title, (String)Messages.FactoryComponentInvocationWizardPage_Name_Tooltip, null, (int)-1, (IValidator)new NotEmptyStringValidator(Messages.FactoryComponentInvocationWizardPage_Name_ErrorMessage), (boolean)this.isReadOnly());
        Text fcInvocationName = this._factoryComponentInvocationNameFieldEditor.getTextControl();
        this.bindTextToAttribute(fcInvocationName, ModelPackage.Literals.NAMED_MODEL_ELEMENT_WITH_ID__NAME, this.getModelElement(), null);
        this._factoryComponentInvocationNameFieldEditor.isValid(true);
    }

    private void createReferencedFactoryComponentFieldEditor(Composite parent_p) {
        FactoryComponentSelectionDialog fcSelectionDialog = new FactoryComponentSelectionDialog(this.getShell());
        FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)this.getParent());
        fcSelectionDialog.setFilteredFactoryComponents(Collections.singletonList(fcContainer));
        ReferencedFactoryComponentValidator validator = new ReferencedFactoryComponentValidator(Messages.FactoryComponentInvocationWizardPage_ReferencedFactoryComponent_ErrorMessage){

            protected void handleReferencedFactoryComponentChange(String newReferencedFcIdValue_p) {
                FactoryComponentInvocationWizardPage.this._referencedFactoryComponentId = newReferencedFcIdValue_p;
            }
        };
        this._referencedFactoryComponentFieldEditor = ModelElementButtonFieldEditor.createModelElementButtonFieldEditor(parent_p, (DialogPage)this, Messages.FactoryComponentInvocationWizardPage_ReferencedFactoryComponent_Title, Messages.FactoryComponentInvocationWizardPage_ReferencedFactoryComponent_Tooltip, fcSelectionDialog, (IValidator)validator, this.isReadOnly());
        FactoryComponentInvocation fcInvocation = this.getFactoryComponentInvocation();
        FactoryComponent referenceFc = CoreActivator.getDefault().getFactoryComponent(fcInvocation.getFactoryComponentId());
        String referencedFcName = referenceFc != null ? referenceFc.getName() : "";
        ReferencedFactoryComponent referencedFc = new ReferencedFactoryComponent(referencedFcName);
        Text referencedFcNameText = this._referencedFactoryComponentFieldEditor.getTextControl(parent_p);
        ValueChangeHandler valueChangeHandler = new ValueChangeHandler(this){

            protected void doHandleValueChange(ValueChangeEvent event_p) {
                FactoryComponentInvocationWizardPage.this.getFactoryComponentInvocation().setFactoryComponentId(FactoryComponentInvocationWizardPage.this._referencedFactoryComponentId);
            }
        };
        this.bindTextToAttribute(referencedFcNameText, "name", referencedFc, (UpdateWizardPage)valueChangeHandler);
        this._referencedFactoryComponentFieldEditor.isValid(true);
    }

    protected void handlePageLayout(Composite parent_p) {
        FieldEditorHelper.layoutFieldEditor((Composite)parent_p, (FieldEditor)this._factoryComponentInvocationNameFieldEditor, (int)3);
    }

    protected boolean getCompleteStatus() {
        IFieldEditor[] fieldEditors = new IFieldEditor[]{this._factoryComponentInvocationNameFieldEditor, this._referencedFactoryComponentFieldEditor};
        return this.handleFieldEditorValidation(fieldEditors);
    }

    protected String getPageTitle() {
        return Messages.FactoryComponentInvocationWizardPage_Title;
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_FC_CONFIGURATION_WIZARD_PAGE;
    }
}

