/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.common.ui.field.ValidatingStringButtonFieldEditor;
import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.ValidatingStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.egf.common.ui.toolkit.validators.NotEmptyStringValidator;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.core.ui.internal.databinding.ReferencedFactoryComponent;
import org.eclipse.egf.core.ui.internal.databinding.UpdateWizardPage;
import org.eclipse.egf.core.ui.internal.databinding.ValueChangeHandler;
import org.eclipse.egf.core.ui.internal.dialogs.FactoryComponentSelectionDialog;
import org.eclipse.egf.core.ui.internal.field.ModelElementButtonFieldEditor;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.internal.validators.ReferencedFactoryComponentValidator;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.model.Domain;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.MappingModel;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MappingWizardPage
extends AbstractModelElementWizardPage {
    protected static final String MAPPING_RELATIVE_FOLDER_PATH = "model/mapping";
    private static final String MAPPING_FILE_EXTENSION = ".ecore2ecore";
    private ValidatingStringFieldEditor _mappingNameFieldEditor;
    private ValidatingStringFieldEditor _mappingIdFieldEditor;
    private ValidatingStringButtonFieldEditor _fcAsSourceFieldEditor;
    protected String _fcIdForSource;
    private ValidatingStringButtonFieldEditor _fcAsTargetFieldEditor;
    protected String _fcIdForTarget;

    public MappingWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public MappingWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected void createPageArea(Composite parent_p) {
        this.createMappingIdFieldEditor(parent_p);
        this.createMappingNameFieldEditor(parent_p);
        this.createMappingSourceFieldEditor(parent_p);
        this.createMappingTargetFieldEditor(parent_p);
        this.handlePageLayout(parent_p);
    }

    protected void handlePageLayout(Composite parent_p) {
        FieldEditorHelper.layoutFieldEditor((Composite)parent_p, (FieldEditor)this._mappingIdFieldEditor, (int)3);
        FieldEditorHelper.layoutFieldEditor((Composite)parent_p, (FieldEditor)this._mappingNameFieldEditor, (int)3);
    }

    private void createMappingSourceFieldEditor(Composite parent_p) {
        ReferencedFactoryComponentValidator validator = new ReferencedFactoryComponentValidator(Messages.MappingWizardPage_FcAsSource_ErrorMessage){

            protected void handleReferencedFactoryComponentChange(String newReferencedFcIdValue_p) {
                MappingWizardPage.this._fcIdForSource = newReferencedFcIdValue_p;
            }
        };
        this._fcAsSourceFieldEditor = ModelElementButtonFieldEditor.createModelElementButtonFieldEditor(parent_p, (DialogPage)this, Messages.MappingWizardPage_FcAsSource_Title, Messages.MappingWizardPage_FcAsSource_Tooltip, this.createFactoryComponentSelectionDialog(), (IValidator)validator, this.isReadOnly());
        FactoryComponent fcAsSource = CoreActivator.getDefault().getFactoryComponent(this.getMappingModel().getSource());
        String referencedFcSourceName = fcAsSource != null ? fcAsSource.getName() : "";
        ReferencedFactoryComponent referencedFcAsSource = new ReferencedFactoryComponent(referencedFcSourceName);
        Text referencedFcSourceNameText = this._fcAsSourceFieldEditor.getTextControl(parent_p);
        ValueChangeHandler valueChangeHandler = new ValueChangeHandler(this){

            protected void doHandleValueChange(ValueChangeEvent event_p) {
                MappingWizardPage.this.getMappingModel().setSource(MappingWizardPage.this._fcIdForSource);
            }
        };
        this.bindTextToAttribute(referencedFcSourceNameText, "name", referencedFcAsSource, (UpdateWizardPage)valueChangeHandler);
        this._fcAsSourceFieldEditor.isValid(true);
    }

    private void createMappingTargetFieldEditor(Composite parent_p) {
        ReferencedFactoryComponentValidator validator = new ReferencedFactoryComponentValidator(Messages.MappingWizardPage_FcAsTarget_ErrorMessage){

            protected void handleReferencedFactoryComponentChange(String newReferencedFcIdValue_p) {
                MappingWizardPage.this._fcIdForTarget = newReferencedFcIdValue_p;
            }
        };
        this._fcAsTargetFieldEditor = ModelElementButtonFieldEditor.createModelElementButtonFieldEditor(parent_p, (DialogPage)this, Messages.MappingWizardPage_FcAsTarget_Title, Messages.MappingWizardPage_FcAsTarget_Tooltip, this.createFactoryComponentSelectionDialog(), (IValidator)validator, this.isReadOnly());
        FactoryComponent fcAsTarget = CoreActivator.getDefault().getFactoryComponent(this.getMappingModel().getTarget());
        String referencedFcTargetName = fcAsTarget != null ? fcAsTarget.getName() : "";
        ReferencedFactoryComponent referencedFcAsTarget = new ReferencedFactoryComponent(referencedFcTargetName);
        Text referencedFcNameAsTargetText = this._fcAsTargetFieldEditor.getTextControl(parent_p);
        ValueChangeHandler valueChangeHandler = new ValueChangeHandler(this){

            protected void doHandleValueChange(ValueChangeEvent event_p) {
                MappingWizardPage.this.getMappingModel().setTarget(MappingWizardPage.this._fcIdForTarget);
            }
        };
        this.bindTextToAttribute(referencedFcNameAsTargetText, "name", referencedFcAsTarget, (UpdateWizardPage)valueChangeHandler);
        this._fcAsTargetFieldEditor.isValid(true);
    }

    private FactoryComponentSelectionDialog createFactoryComponentSelectionDialog() {
        FactoryComponentSelectionDialog fcSelectionDialog = new FactoryComponentSelectionDialog(this.getShell());
        List<FactoryComponent> filteredFcs = EgfUiActivator.getDefault().getTargetPlatformFactoryComponents();
        Iterator<FactoryComponent> iterator = filteredFcs.iterator();
        while (iterator.hasNext()) {
            FactoryComponent currentFc = iterator.next();
            if (!ModelHelper.isDomainDefined((Domain)currentFc.getDomain())) continue;
            iterator.remove();
        }
        filteredFcs.addAll(EgfUiActivator.getDefault().getWorkspaceFactoryComponents());
        fcSelectionDialog.setFilteredFactoryComponents(filteredFcs);
        return fcSelectionDialog;
    }

    private void createMappingIdFieldEditor(Composite parent_p) {
        this._mappingIdFieldEditor = FieldEditorHelper.createStringFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.MappingWizardPage_Id_Title, (String)Messages.MappingWizardPage_Id_Tooltip, null, (int)-1, (IValidator)new NotEmptyStringValidator(Messages.MappingWizardPage_Id_ErrorMessage), (boolean)this.isReadOnly());
        Text mappingIdText = this._mappingIdFieldEditor.getTextControl();
        this.bindTextToAttribute(mappingIdText, ModelPackage.Literals.NAMED_MODEL_ELEMENT_WITH_ID__ID, this.getModelElement(), null);
        this._mappingIdFieldEditor.isValid(true);
    }

    private void createMappingNameFieldEditor(Composite parent_p) {
        this._mappingNameFieldEditor = FieldEditorHelper.createStringFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.MappingWizardPage_Name_Title, (String)Messages.MappingWizardPage_Name_Tooltip, null, (int)-1, (IValidator)new NotEmptyStringValidator(Messages.MappingWizardPage_Name_ErrorMessage), (boolean)this.isReadOnly());
        Text mappingNameText = this._mappingNameFieldEditor.getTextControl();
        ValueChangeHandler handler = new ValueChangeHandler(this){

            protected void doHandleValueChange(ValueChangeEvent event_p) {
                String mappingName = (String)event_p.diff.getNewValue();
                String mappingFilePath = null;
                if (mappingName != null) {
                    String mappingfileName = StringHelper.replaceNonWordCharactersWithDot((String)mappingName);
                    mappingFilePath = MappingWizardPage.MAPPING_RELATIVE_FOLDER_PATH + '/' + mappingfileName + MappingWizardPage.MAPPING_FILE_EXTENSION;
                }
                MappingWizardPage.this.getMappingModel().setPath(mappingFilePath);
            }
        };
        this.bindTextToAttribute(mappingNameText, ModelPackage.Literals.NAMED_MODEL_ELEMENT_WITH_ID__NAME, this.getModelElement(), (UpdateWizardPage)handler);
        this._mappingNameFieldEditor.isValid(true);
    }

    protected boolean getCompleteStatus() {
        IFieldEditor[] fieldEditors = new IFieldEditor[]{this._mappingIdFieldEditor, this._mappingNameFieldEditor, this._fcAsSourceFieldEditor, this._fcAsTargetFieldEditor};
        return this.handleFieldEditorValidation(fieldEditors);
    }

    protected String getPageTitle() {
        return Messages.MappingWizardPage_Title;
    }

    protected MappingModel getMappingModel() {
        return (MappingModel)this.getModelElement();
    }

    protected IFolder getMappingFolder() {
        IFolder result = null;
        IJavaProject hostingProject = this.getHostingProject();
        if (hostingProject != null) {
            IProject project = hostingProject.getProject();
            result = project.getFolder(MAPPING_RELATIVE_FOLDER_PATH);
        }
        return result;
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_MAPPING_WIZARD_PAGE;
    }
}

