/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.common.helper.PatternLibrarySequenceHelper;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractPatternLibrarySequenceWizardPage;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternLibraryProductionSequenceWizardPage
extends AbstractPatternLibrarySequenceWizardPage {
    private List<Object> _productionContent;

    public PatternLibraryProductionSequenceWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public PatternLibraryProductionSequenceWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    public IWizardPage getNextPage() {
        return this.getWizard().getPage("patternLibraryRuntimeSequenceWizardPage");
    }

    @Override
    protected String getOrchestrationValue() {
        return this.getPatternLibrary().getProductionOrchestration();
    }

    @Override
    protected List<Object> getPatternElements(String orchestrationValue_p) {
        List patternElementAsString = PatternLibrarySequenceHelper.extractSequenceIds((String)orchestrationValue_p);
        this._productionContent = new ArrayList<Object>(patternElementAsString.size());
        PatternLibrary library = this.getPatternLibrary();
        for (String patternElementShortId : patternElementAsString) {
            AbstractPatternElement patternElement = ModelHelper.getPatternElement((String)patternElementShortId, (PatternLibrary)library);
            if (patternElement == null) continue;
            this._productionContent.add(patternElement);
        }
        return this._productionContent;
    }

    @Override
    protected List<Object> getFilteredPatternElements() {
        List<Object> result = null;
        result = this._productionContent == null ? Collections.emptyList() : this._productionContent;
        return result;
    }

    protected String getPageTitle() {
        return Messages.PatternLibraryProductionSequenceWizardPage_Title;
    }

    @Override
    public void elementUpdated(List<Object> elements_p) {
        Iterator<Object> patternElements = elements_p.iterator();
        ArrayList<String> orchestrationIds = new ArrayList<String>(elements_p.size());
        while (patternElements.hasNext()) {
            AbstractPatternElement patternElement = (AbstractPatternElement)patternElements.next();
            orchestrationIds.add(ModelHelper.getPatternElementShortId((AbstractPatternElement)patternElement));
        }
        ((PatternLibrary)this.getModelElement()).setProductionOrchestration(PatternLibrarySequenceHelper.getFullSequence(orchestrationIds));
        this._productionContent = elements_p;
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_PATTERN_LIBRARY_PRODUCTION_WIZARD_PAGE;
    }
}

