/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egf.common.listener.AbstractProjectListener;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryComponentRegistry {
    private static FactoryComponentRegistry __instance;
    Map<String, FactoryComponent> _factoryComponents = new HashMap<String, FactoryComponent>(0);

    private FactoryComponentRegistry() {
        this.initializeListeners();
    }

    private void initializeListeners() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ProjectListener());
    }

    public static synchronized FactoryComponentRegistry getInstance() {
        if (__instance == null) {
            __instance = new FactoryComponentRegistry();
        }
        return __instance;
    }

    public synchronized FactoryComponent getFactoryComponent(String factoryComponentId_p) {
        return this._factoryComponents.get(factoryComponentId_p);
    }

    public synchronized FactoryComponent removeFactoryComponent(String factoryComponentId_p) {
        return this._factoryComponents.remove(factoryComponentId_p);
    }

    public synchronized boolean removeFactoryComponents(Collection<FactoryComponent> factoryComponents_p) {
        return this._factoryComponents.values().removeAll(factoryComponents_p);
    }

    public synchronized void addFactoryComponent(String factoryComponentId_p, FactoryComponent factoryComponent_p) {
        this._factoryComponents.put(factoryComponentId_p, factoryComponent_p);
    }

    public synchronized List<FactoryComponent> getFactoryComponents() {
        return new ArrayList<FactoryComponent>(this._factoryComponents.values());
    }

    class ProjectListener
    extends AbstractProjectListener {
        ProjectListener() {
        }

        protected void handleProjectAdded(IProject project_p, IResourceDelta resourceDelta_p) {
        }

        protected void handleProjectChanged(IProject project_p, IResourceDelta resourceDelta_p) {
        }

        protected void handleProjectRemoved(IProject project_p, IResourceDelta resourceDelta_p) {
            Iterator<FactoryComponent> iteratorOverFcs = FactoryComponentRegistry.this._factoryComponents.values().iterator();
            boolean removed = false;
            while (iteratorOverFcs.hasNext() && !removed) {
                FactoryComponent currentFc = iteratorOverFcs.next();
                IProject currentFcProject = ModelHelper.getProject((NamedModelElementWithId)currentFc);
                if (project_p != currentFcProject) continue;
                removed = true;
                iteratorOverFcs.remove();
            }
        }

        protected void handleProjectClosed(IProject project_p, IResourceDelta resourceDelta_p) {
            this.handleProjectRemoved(project_p, resourceDelta_p);
        }
    }
}

