/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.internal.production;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.context.ProductionContext;
import org.eclipse.egf.core.data.helper.DataHelper;
import org.eclipse.egf.core.internal.production.Messages;
import org.eclipse.egf.core.task.AbstractTask;
import org.eclipse.egf.core.task.ITaskFactory;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.Contract;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.ProductionPlan;
import org.eclipse.egf.model.TaskFactoryHolder;
import org.eclipse.egf.model.contract.type.ITypeHolder;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionManager {
    static final Logger __logger = Logger.getLogger((String)ProductionManager.class.getPackage().getName());

    public boolean generate(String factoryComponentId_p, IProgressMonitor progressMonitor_p) {
        boolean result = true;
        IProgressMonitor progressMonitor = progressMonitor_p;
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        ArrayList<AbstractTask> tasksList = new ArrayList<AbstractTask>(0);
        this.generate(factoryComponentId_p, null, tasksList);
        String generationMessage = String.valueOf(Messages.ProductionManager_ProgressReporting_Title) + factoryComponentId_p;
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor_p, (String)generationMessage, (int)(tasksList.size() * 1000));
            Iterator tasks = tasksList.iterator();
            while (tasks.hasNext() && !progressMonitor.isCanceled()) {
                result &= ((AbstractTask)tasks.next()).execute((IProgressMonitor)subMonitor.newChild(1000), 1000);
            }
        }
        catch (Throwable throwable) {
            progressMonitor.done();
            result &= !progressMonitor.isCanceled();
            throw throwable;
        }
        progressMonitor.done();
        return result &= !progressMonitor.isCanceled();
    }

    private void generate(String factoryComponentId_p, ProductionContext productionContext_p, List<AbstractTask> resultingTasks_p) {
        FactoryComponent fc = CoreActivator.getDefault().getFactoryComponent(factoryComponentId_p);
        if (fc == null) {
            StringBuffer loggerMessage = new StringBuffer("ProductionManager.generate(..) _ ");
            loggerMessage.append("Unable to generate factory component:");
            loggerMessage.append(factoryComponentId_p);
            loggerMessage.append(", factory component not found.");
            __logger.error((Object)loggerMessage.toString());
            return;
        }
        ProductionContext productionContext = new ProductionContext(productionContext_p);
        ProductionPlan productionPlan = ModelHelper.getProductionPlan((FactoryComponent)fc);
        Context productionPlanContext = productionPlan.getContext();
        EList contractElements = null;
        Contract contract = ModelHelper.getContract((FactoryComponent)fc);
        contractElements = contract != null ? contract.getContractElements() : Collections.emptyList();
        this.feedProductionContext(productionContext, productionPlanContext, factoryComponentId_p, (List<ContractElement>)contractElements);
        for (FactoryComponentInvocation fcInvocation : productionPlan.getFactoryComponentInvocations()) {
            Context fcInvocationContext = fcInvocation.getContext();
            ProductionContext fcInvocationProductionContext = new ProductionContext(productionContext);
            this.feedProductionContext(fcInvocationProductionContext, fcInvocationContext, fcInvocation.getFactoryComponentId());
            String taskFactoryId = fcInvocation.getTaskFactoryId();
            if (taskFactoryId != null) {
                TaskFactoryHolder taskFactoryHolder = fcInvocation.getTaskFactory();
                ITaskFactory taskFactory = (ITaskFactory)taskFactoryHolder.getFactory();
                AbstractTask task = taskFactory.createTask();
                task.setFactoryComponentId(factoryComponentId_p);
                task.setProductionContext(fcInvocationProductionContext);
                resultingTasks_p.add(task);
                continue;
            }
            this.generate(fcInvocation.getFactoryComponentId(), fcInvocationProductionContext, resultingTasks_p);
        }
    }

    private void feedProductionContext(ProductionContext productionContext_p, Context context_p, String localFactoryComponentId_p) {
        if (productionContext_p == null || context_p == null) {
            return;
        }
        for (ContextElement contextElement : context_p.getContextElements()) {
            String contextElementPluginId = contextElement.getPluginId();
            Object contextValue = null;
            ContractElementReference contractElementReference = contextElement.getContractElementReference();
            if (contractElementReference != null) {
                this.addContractElementReferenceValue(productionContext_p, contractElementReference, contextElement.getReadableValue(), true, contextElementPluginId);
                continue;
            }
            ITypeHolder typeHolder = (ITypeHolder)contextElement.getContextType().getTypeHolder();
            typeHolder.setPluginId(contextElementPluginId);
            contextValue = typeHolder.getValue(contextElement.getReadableValue());
            if (contextValue != null) {
                productionContext_p.addContextElement(contextElement.getKey(), contextValue, localFactoryComponentId_p);
                continue;
            }
            StringBuilder loggerMessage = new StringBuilder("ProductionManager.initializeProductionContext(..) _ ");
            loggerMessage.append("Could not interpret ").append(contextElement.getReadableValue());
            loggerMessage.append(" using registered ").append(typeHolder.getClass().getName()).append(" !");
            __logger.error((Object)loggerMessage.toString());
        }
    }

    private void feedProductionContext(ProductionContext productionContext_p, Context productionPlanContext_p, String localFactoryComponentId_p, List<ContractElement> contractElements_p) {
        this.feedProductionContext(productionContext_p, productionPlanContext_p, localFactoryComponentId_p);
        if (contractElements_p.isEmpty()) {
            return;
        }
        for (ContractElement contractElement : contractElements_p) {
            Object value = productionContext_p.getContextElementValue(contractElement.getName(), localFactoryComponentId_p);
            if (value == null) continue;
            for (ContractElementReference contractElementReference : contractElement.getContractElementReferences()) {
                this.addContractElementReferenceValue(productionContext_p, contractElementReference, value, false, null);
            }
        }
    }

    private void addContractElementReferenceValue(ProductionContext productionContext_p, ContractElementReference reference_p, Object value_p, boolean decodeValue_p, String pluginId_p) {
        DataHelper.resolveContractElement(reference_p);
        ContractElement contractElement = reference_p.getReferencedContractElement();
        String contractElementName = contractElement.getName();
        String contractElementFcId = contractElement.getFactoryComponentId();
        Object existingValue = productionContext_p.getContextElementValue(contractElementName, contractElementFcId);
        if (existingValue != null) {
            return;
        }
        Object value = null;
        if (decodeValue_p) {
            ITypeHolder typeHolder = (ITypeHolder)contractElement.getContractType().getTypeHolder();
            if (pluginId_p != null) {
                typeHolder.setPluginId(pluginId_p);
            }
            if ((value = typeHolder.getValue((String)value_p)) == null) {
                StringBuffer loggerMessage = new StringBuffer("ProductionManager.addContractElementReferenceValue(..) _ ");
                loggerMessage.append("ContractElement ");
                loggerMessage.append(contractElementName);
                loggerMessage.append(" and Element are not compatible.").append('\n');
                loggerMessage.append("ContractElement expected type holder :");
                loggerMessage.append(typeHolder.getClass().getName()).append('\n');
                loggerMessage.append("Element value :");
                loggerMessage.append(decodeValue_p);
                __logger.error((Object)loggerMessage.toString());
            }
        } else {
            value = value_p;
        }
        if (value != null) {
            productionContext_p.addContextElement(contractElementName, value, contractElementFcId);
        }
    }
}

