/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.helper;

import org.eclipse.egf.common.misc.Couple;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormHelper {
    public static Composite createCompositeWithLayoutType(FormToolkit toolkit_p, Composite parent_p, LayoutType layoutType_p, int numColumns_p, boolean equalWidth_p) {
        Composite result = toolkit_p.createComposite(parent_p);
        FormHelper.updateCompositeLayoutWithLayoutType(result, layoutType_p, numColumns_p, equalWidth_p);
        return result;
    }

    public static Object updateCompositeLayoutWithLayoutType(Composite composite_p, LayoutType layoutType_p, int numColumns_p, boolean equalWidth_p) {
        GridLayout selectedLayout = null;
        if (LayoutType.GRID_LAYOUT.equals((Object)layoutType_p)) {
            GridLayout layout = new GridLayout();
            layout.numColumns = numColumns_p;
            layout.makeColumnsEqualWidth = equalWidth_p;
            selectedLayout = layout;
        } else if (LayoutType.TABLEWRAP_LAYOUT.equals((Object)layoutType_p)) {
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = numColumns_p;
            layout.makeColumnsEqualWidth = equalWidth_p;
            selectedLayout = layout;
        }
        if (selectedLayout != null) {
            composite_p.setLayout(selectedLayout);
            FormHelper.updateControlLayoutDataWithLayoutTypeData((Control)composite_p, layoutType_p);
        }
        return selectedLayout;
    }

    public static Object updateControlLayoutDataWithLayoutTypeData(Control control_p, LayoutType layoutType_p) {
        GridData layoutData = null;
        if (LayoutType.GRID_LAYOUT.equals((Object)layoutType_p)) {
            layoutData = new GridData(4, 4, true, true);
        } else if (LayoutType.TABLEWRAP_LAYOUT.equals((Object)layoutType_p)) {
            layoutData = new TableWrapData(256);
        }
        if (layoutData != null) {
            control_p.setLayoutData((Object)layoutData);
        }
        return layoutData;
    }

    public static Couple<Section, Composite> createSectionWithChildComposite(FormToolkit toolkit_p, Composite parent_p, int sectionStyle_p, LayoutType layoutType_p, int childNumColumns_p, boolean equalWidth_p) {
        Section resultingSection = toolkit_p.createSection(parent_p, sectionStyle_p);
        FormHelper.updateControlLayoutDataWithLayoutTypeData((Control)resultingSection, layoutType_p);
        Composite childComposite = FormHelper.createCompositeWithLayoutType(toolkit_p, (Composite)resultingSection, layoutType_p, childNumColumns_p, equalWidth_p);
        resultingSection.setClient((Control)childComposite);
        return new Couple((Object)resultingSection, (Object)childComposite);
    }

    public static Couple<Label, Text> createLabelAndText(FormToolkit toolkit_p, Composite parent_p, String labelMessage_p, String initialText_p, boolean editable_p) {
        Label label = toolkit_p.createLabel(parent_p, labelMessage_p, 64);
        label.setForeground(toolkit_p.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text text = new Text(parent_p, editable_p ? 2048 : 2056);
        text.setLayoutData((Object)new GridData(768));
        if (initialText_p != null) {
            text.setText(initialText_p);
        }
        return new Couple((Object)label, (Object)text);
    }

    public static Couple<Text, Button> createLabelTextAndButton(FormToolkit toolkit_p, Composite parent_p, String labelMessage_p, String buttonLabel_p, SelectionListener listener_p) {
        Couple<Label, Text> labelAndText = FormHelper.createLabelAndText(toolkit_p, parent_p, labelMessage_p, null, true);
        Button button = toolkit_p.createButton(parent_p, buttonLabel_p, 8);
        if (listener_p != null) {
            button.addSelectionListener(listener_p);
        }
        return new Couple((Object)((Text)labelAndText.getValue()), (Object)button);
    }

    public static void createLinkWithDescription(FormToolkit toolkit_p, Composite parent_p, Image icon_p, String linkText_p, Object linkRef_p, String linkDescription_p, IHyperlinkListener listener_p) {
        ImageHyperlink specificationLink = toolkit_p.createImageHyperlink(parent_p, 64);
        specificationLink.setText(linkText_p);
        specificationLink.setImage(icon_p);
        specificationLink.setHref(linkRef_p);
        specificationLink.addHyperlinkListener(listener_p);
        toolkit_p.createLabel(parent_p, linkDescription_p, 64);
    }

    public static void forceControlSize(Control control_p, int widthInChars_p, int heightInChars_p) {
        if (control_p == null || widthInChars_p <= 0 || heightInChars_p <= 0) {
            return;
        }
        GC gc = new GC((Drawable)control_p);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Object layoutData = control_p.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData data = (GridData)layoutData;
            data.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)widthInChars_p);
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)heightInChars_p);
        } else if (layoutData instanceof TableWrapData) {
            TableWrapData data = (TableWrapData)layoutData;
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)heightInChars_p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LayoutType {
        GRID_LAYOUT,
        TABLEWRAP_LAYOUT;

    }
}

