/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.internal.helper;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.IUserEnforcedHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UserEnforcedHelper
implements IUserEnforcedHelper {
    private static final Logger __logger = Logger.getLogger((String)UserEnforcedHelper.class.getPackage().getName());

    public IStatus makeFileWritable(final IFile file_p) {
        final IStatus[] result = new IStatus[]{Status.CANCEL_STATUS};
        final Display display = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getDisplay() : null;
        Runnable makeFileWritableRunnable = new Runnable(){

            public void run() {
                result[0] = UserEnforcedHelper.this.makeFileWritable(file_p, display);
            }
        };
        if (display != null) {
            display.syncExec(makeFileWritableRunnable);
        } else {
            makeFileWritableRunnable.run();
        }
        return result[0];
    }

    public IStatus makeFileWritable(IFile file_p, Object display_p) {
        IStatus result = Status.CANCEL_STATUS;
        if (file_p == null) {
            return result;
        }
        if (!file_p.exists()) {
            return Status.OK_STATUS;
        }
        Shell shell = null;
        if (display_p instanceof Display) {
            shell = ((Display)display_p).getActiveShell();
        }
        Object context = shell == null ? IWorkspace.VALIDATE_PROMPT : shell;
        result = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file_p}, context);
        if (!result.isOK()) {
            StringBuilder loggerMessage = new StringBuilder("UserEnforcedHelper.makeFileWritable(..) _ ");
            loggerMessage.append("Could not make ").append(file_p.getFullPath()).append(" writable !");
            __logger.error((Object)loggerMessage.toString());
        }
        return result;
    }
}

