/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.toolkit.fields;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractFieldEditor
extends FieldEditor
implements IFieldEditor {
    protected int _labelStyle = 16384;
    protected int _valueStyle = 0;
    private IValidator _validator = null;
    private String _errorMessage = null;

    protected AbstractFieldEditor() {
    }

    protected AbstractFieldEditor(String name_p, String labelText_p, Composite parent_p) {
        this(name_p, labelText_p, parent_p, 16384, 0);
    }

    protected AbstractFieldEditor(String name_p, String labelText_p, Composite parent_p, int labelStyle_p, int valueStyle_p) {
        this.init(name_p, labelText_p, labelStyle_p, valueStyle_p);
        this.createControl(parent_p);
    }

    protected void init(String name_p, String text_p, int labelStyle_p, int valueStyle_p) {
        Assert.isNotNull((Object)name_p);
        Assert.isNotNull((Object)text_p);
        this._labelStyle = this.checkLabelStyle(labelStyle_p);
        this._valueStyle = this.checkValueStyle(valueStyle_p);
        this.setPreferenceName(name_p);
        this.setLabelText(text_p);
    }

    private int checkLabelStyle(int labelStyle_p) {
        int newStyle = labelStyle_p;
        if ((2 & newStyle) != 0) {
            newStyle -= 2;
        }
        if ((0x40 & newStyle) != 0) {
            newStyle -= 64;
        }
        if (newStyle == 0) {
            newStyle = 16384;
        }
        return newStyle;
    }

    protected int checkValueStyle(int valueStyle_p) {
        return valueStyle_p;
    }

    protected void createControl(Composite parent_p) {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.horizontalSpacing = 8;
        parent_p.setLayout((Layout)layout);
        this.doFillIntoGrid(parent_p, layout.numColumns);
    }

    public Label getLabelControl(Composite parent_p) {
        Label label = super.getLabelControl(parent_p);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        label.setLayoutData((Object)gd);
        int alignement = 0x20000 & this._labelStyle;
        if (alignement == 0) {
            alignement = 0x1000000 & this._labelStyle;
        }
        if (alignement == 0) {
            alignement = 16384;
        }
        label.setAlignment(alignement);
        return label;
    }

    public void setErrorMessage(String message_p) {
        this._errorMessage = message_p;
    }

    protected abstract void doFillIntoGrid(Composite var1, int var2);

    protected abstract Object getValue(Control var1);

    public Label getLabel() {
        return this.getLabelControl();
    }

    public abstract Control getValueControl();

    public abstract Control getHelperControl();

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public IValidator getValidator() {
        return this._validator;
    }

    public void setValidator(IValidator validator_p) {
        this._validator = validator_p;
    }

    public boolean isValid() {
        boolean isValid = true;
        if (this._validator != null) {
            Control control = this.getValueControl();
            Object value = this.getValue(control);
            String oldMessage = this._errorMessage;
            this._errorMessage = this._validator.isValid(value);
            boolean bl = isValid = this._errorMessage == null;
            if (this.getPage() != null) {
                if (!isValid && this.getPage().getErrorMessage() == null) {
                    this.showErrorMessage(this._errorMessage);
                } else if (isValid && this.getPage().getErrorMessage() == oldMessage) {
                    this.clearErrorMessage();
                }
            }
        }
        return isValid;
    }

    protected boolean doCheckState() {
        return this.isValid();
    }

    public String getFieldName() {
        return this.getPreferenceName();
    }

    public DialogPage getFieldPage() {
        return this.getPage();
    }

    public void setFieldPage(DialogPage page_p) {
        this.setPage(page_p);
    }

    public boolean isHelperEnabled() {
        boolean enabled = false;
        Control helperControl = this.getHelperControl();
        if (helperControl != null) {
            enabled = helperControl.isEnabled();
        }
        return enabled;
    }

    public void setHelperEnabled(boolean enabled_p) {
        Control helperControl = this.getHelperControl();
        if (helperControl != null) {
            helperControl.setEnabled(enabled_p);
        }
    }

    public boolean isValueEnabled() {
        boolean enabled = false;
        Control valueControl = this.getValueControl();
        if (valueControl != null) {
            enabled = valueControl.isEnabled();
        }
        return enabled;
    }

    public void setValueEnabled(boolean enabled_p) {
        Control valueControl = this.getValueControl();
        if (valueControl != null) {
            valueControl.setEnabled(enabled_p);
        }
    }

    public void setFocus() {
        Control valueControl = this.getValueControl();
        if (valueControl != null) {
            valueControl.setFocus();
        }
    }

    public boolean isFocused() {
        Control valueControl = this.getValueControl();
        Control helperControl = this.getHelperControl();
        boolean focused = false;
        if (valueControl != null) {
            focused = valueControl.isFocusControl();
        }
        if (helperControl != null) {
            focused |= helperControl.isFocusControl();
        }
        return focused;
    }

    public void defaultLayout() {
        Composite parent = this.getLabelControl().getParent();
        GridLayout layout = (GridLayout)parent.getLayout();
        this.fillIntoGrid(parent, layout.numColumns);
    }

    public void layout(int numColumns_p) {
        this.adjustForNumColumns(numColumns_p);
    }
}

