/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.toolkit.fields;

import org.apache.log4j.Logger;
import org.eclipse.egf.common.ui.toolkit.fields.AbstractFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class CStringFieldEditor
extends AbstractFieldEditor {
    private static final Logger __logger = Logger.getLogger((String)CStringFieldEditor.class.getPackage().getName());
    private boolean _isValid = false;
    private String _oldValue = null;
    private int _widthInChars = UNLIMITED;
    private int _textLimit = UNLIMITED;
    private boolean _emptyStringAllowed = true;
    private int _validateStrategy = 0;
    protected Text _textField;
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static final int VALIDATE_ON_MODIFICATION = 2;
    public static int UNLIMITED = -1;

    public CStringFieldEditor(String name_p, String label_p, Composite parent_p) {
        this(name_p, label_p, UNLIMITED, parent_p, 2052);
    }

    public CStringFieldEditor(String name_p, String label_p, Composite parent_p, int valueStyle_p) {
        this(name_p, label_p, UNLIMITED, parent_p, valueStyle_p);
    }

    public CStringFieldEditor(String name_p, String label_p, int width_p, Composite parent_p, int valueStyle_p) {
        this(name_p, label_p, width_p, 0, parent_p, valueStyle_p);
    }

    public CStringFieldEditor(String name_p, String label_p, int width_p, int strategy_p, Composite parent_p, int valueStyle_p) {
        this.init(name_p, label_p, 16384, valueStyle_p);
        this._widthInChars = width_p;
        this.setValidateStrategy(strategy_p);
        this._isValid = false;
        this.setErrorMessage(JFaceResources.getString((String)"StringFieldEditor.errorMessage"));
        this.createControl(parent_p);
    }

    protected void adjustForNumColumns(int numColumns_p) {
        GridData gd = (GridData)this._textField.getLayoutData();
        gd.horizontalSpan = numColumns_p - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected boolean checkState() {
        String txt;
        boolean result = false;
        boolean wasValid = this._isValid;
        if (this._emptyStringAllowed) {
            result = true;
        }
        if (this._textField == null) {
            result = false;
        }
        result = (txt = this._textField.getText()).trim().length() > 0 || this._emptyStringAllowed;
        boolean bl = result = result && this.doCheckState();
        if (!wasValid && result) {
            this.clearErrorMessage();
        } else if (!result) {
            this.showErrorMessage(this.getErrorMessage());
        }
        return result;
    }

    protected void doFillIntoGrid(Composite parent_p, int numColumns_p) {
        this.getLabelControl(parent_p);
        this._textField = this.getTextControl(parent_p);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns_p - 1;
        if (this._widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this._textField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this._widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        if ((this._textField.getStyle() & 2) != 0) {
            gd.verticalAlignment = 4;
            gd.verticalSpan = 2;
            gd.grabExcessVerticalSpace = true;
        }
        this._textField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this._textField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this._textField.setText(value == null ? "" : value);
            this._oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this._textField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this._textField.setText(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this._textField.getText());
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this._textField != null) {
            return this._textField.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    public Text getTextControl() {
        return this._textField;
    }

    protected int checkValueStyle(int valueStyle_p) {
        int newStyle = valueStyle_p;
        if ((0x800 & valueStyle_p) == 0) {
            newStyle |= 0x800;
        }
        if (2048 == this._valueStyle) {
            newStyle |= 4;
        }
        return newStyle;
    }

    protected Text getTextControl(Composite parent_p) {
        if (this._textField == null) {
            this._textField = this.doTextControl(parent_p, this._valueStyle);
            this._textField.setFont(parent_p.getFont());
            switch (this._validateStrategy) {
                case 0: {
                    this._textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent event_p) {
                            CStringFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 2: {
                    this._textField.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent event_p) {
                            CStringFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this._textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent event_p) {
                            CStringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this._textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent event_p) {
                            CStringFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent event_p) {
                            CStringFieldEditor.this.valueChanged();
                            CStringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    StringBuilder loggerMessage = new StringBuilder("CStringFieldEditor.getTextControl(..) _ ");
                    loggerMessage.append("Unknown validate strategy");
                    __logger.error((Object)loggerMessage.toString());
                }
            }
            this._textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event_p) {
                    CStringFieldEditor.this._textField = null;
                }
            });
            if (this._textLimit > 0) {
                this._textField.setTextLimit(this._textLimit);
            }
        } else {
            this.checkParent((Control)this._textField, parent_p);
        }
        return this._textField;
    }

    protected Text doTextControl(Composite parent_p, int style_p) {
        return new Text(parent_p, style_p);
    }

    public boolean isEmptyStringAllowed() {
        return this._emptyStringAllowed;
    }

    public boolean isValid() {
        return this._isValid;
    }

    protected void refreshValidState() {
        this._isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean allowed_p) {
        this._emptyStringAllowed = allowed_p;
    }

    public void setFocus() {
        if (this._textField != null) {
            this._textField.setFocus();
        }
    }

    public void setStringValue(String value_p) {
        String value = value_p;
        if (this._textField != null) {
            if (value == null) {
                value = "";
            }
            this._oldValue = this._textField.getText();
            if (!this._oldValue.equals(value)) {
                this._textField.setText(value);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit_p) {
        this._textLimit = limit_p;
        if (this._textField != null) {
            this._textField.setTextLimit(limit_p);
        }
    }

    public void setValidateStrategy(int value_p) {
        if (value_p == 1 || value_p == 0 || value_p == 2) {
            this._validateStrategy = value_p;
        } else {
            StringBuilder loggerMessage = new StringBuilder("CStringFieldEditor.setValidateStrategy(..) _ ");
            loggerMessage.append("Validation strategy unknown");
            __logger.error((Object)loggerMessage.toString());
        }
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.getErrorMessage());
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this._isValid;
        this.refreshValidState();
        if (this._isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this._isValid);
        }
        if (!(newValue = this._textField.getText()).equals(this._oldValue)) {
            this.fireValueChanged("field_editor_value", this._oldValue, newValue);
            this._oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled_p, Composite parent_p) {
        super.setEnabled(enabled_p, parent_p);
        this.getTextControl(parent_p).setEnabled(enabled_p);
    }

    public Control getHelperControl() {
        return null;
    }

    protected Object getValue(Control control_p) {
        return this._textField.getText();
    }

    public Control getValueControl() {
        return this._textField;
    }
}

