/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.toolkit.validators;

import org.eclipse.egf.common.ui.toolkit.validators.RegExpValidator;

public abstract class RegExpValidatorFactory {
    private final String _id;
    public static final RegExpValidatorFactory ONLY_DIGITS = new RegExpValidatorFactory("onlyDigits"){

        public RegExpValidator create(String errorMessage_p) {
            return new RegExpValidator(errorMessage_p, "\\d*");
        }
    };
    public static final RegExpValidatorFactory ONLY_LOWER_CASE = new RegExpValidatorFactory("onlyLowerCase"){

        public RegExpValidator create(String errorMessage_p) {
            return new RegExpValidator(errorMessage_p, "\\p{Lower}");
        }
    };
    public static final RegExpValidatorFactory ONLY_UPPER_CASE = new RegExpValidatorFactory("onlyUpperCase"){

        public RegExpValidator create(String errorMessage_p) {
            return new RegExpValidator(errorMessage_p, "\\{Upper}");
        }
    };
    public static final RegExpValidatorFactory NOT_NUMERIC_START = new RegExpValidatorFactory("notNumericStart"){

        public RegExpValidator create(String errorMessage_p) {
            return new RegExpValidator(errorMessage_p, "\\D+(.| )+");
        }
    };
    public static final RegExpValidatorFactory NO_PUNCTUATION = new RegExpValidatorFactory("noPunctuation"){

        public RegExpValidator create(String errorMessage_p) {
            return new RegExpValidator(errorMessage_p, "[^\\p{Punct}]*");
        }
    };
    public static final RegExpValidatorFactory NO_SPACE = new RegExpValidatorFactory("noSpace"){

        public RegExpValidator create(String errorMessage_p) {
            return new RegExpValidator(errorMessage_p, "[^\\s]*");
        }
    };
    public static final RegExpValidatorFactory IP_DIGIT = new RegExpValidatorFactory("ipDigit"){

        public RegExpValidator create(String errorMessage_p) {
            return new RegExpValidator(errorMessage_p, "[1]{0,1}\\d{0,2}|[2][0-5]{0,2}");
        }
    };
    public static final RegExpValidatorFactory NOT_EMPTY = new RegExpValidatorFactory("notEmpty"){

        public RegExpValidator create(String errorMessage_p) {
            return new RegExpValidator(errorMessage_p, ".+");
        }
    };

    protected RegExpValidatorFactory(String validatorId_p) {
        this._id = validatorId_p;
    }

    public abstract RegExpValidator create(String var1);

    public String getId() {
        return this._id;
    }
}

