/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.common.ui.toolkit.widgets.handler.SelectionChangedHandler;
import org.eclipse.egf.common.ui.viewers.AbstractViewerWithButtons;
import org.eclipse.egf.common.ui.viewers.IButtonClickedListener;
import org.eclipse.egf.common.ui.viewers.IOrderedContentProvider;
import org.eclipse.egf.common.ui.viewers.Messages;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedListViewer
extends AbstractViewerWithButtons {
    private static final Object UP_BUTTON_DATA = new Object();
    private static final Object DOWN_BUTTON_DATA = new Object();
    private static String[] __buttonsLabels = new String[]{Messages.SortedListViewer_UpButton_Title, Messages.SortedListViewer_DownButton_Title};
    private static int[] __buttonsStyles = new int[]{8, 8};
    private static final int DEFAULT_LIST_VIEWER_STYLE = 2820;
    private SelectionChangedHandler _selectionChangedHandlerForUpButton;
    private SelectionChangedHandler _selectionChangedHandlerForDownButton;

    public OrderedListViewer(Composite parent_p) {
        super(parent_p);
        this.setButtonClickedListener(new IButtonClickedListener(){

            public void buttonClicked(Button clickedButton_p, Object data_p) {
                StructuredViewer decoratedViewer = OrderedListViewer.this.getDecoratedViewer();
                ISelection selection = decoratedViewer.getSelection();
                if (UP_BUTTON_DATA.equals(data_p) || DOWN_BUTTON_DATA.equals(data_p)) {
                    if (selection.isEmpty()) {
                        return;
                    }
                    int selectionElementIndex = OrderedListViewer.this.getSelectionIndex();
                    int elementToSwapWithIndex = 0;
                    if (UP_BUTTON_DATA.equals(data_p)) {
                        elementToSwapWithIndex = selectionElementIndex - 1;
                    } else if (DOWN_BUTTON_DATA.equals(data_p)) {
                        elementToSwapWithIndex = selectionElementIndex + 1;
                    }
                    IContentProvider contentProvider = decoratedViewer.getContentProvider();
                    if (contentProvider instanceof IOrderedContentProvider) {
                        ((IOrderedContentProvider)contentProvider).swap(selectionElementIndex, elementToSwapWithIndex);
                    }
                } else {
                    OrderedListViewer.this.delegateButtonClicked(clickedButton_p, data_p);
                }
            }
        });
    }

    protected void delegateButtonClicked(Button clickedButton_p, Object data_p) {
    }

    private void initializeSelectionChangedHandlers() {
        this._selectionChangedHandlerForUpButton = new SelectionChangedHandler(){

            protected boolean doHandleSelection(ISelection selection_p) {
                boolean result = false;
                int selectionIndex = OrderedListViewer.this.getSelectionIndex();
                result = selectionIndex != 0;
                return result;
            }
        };
        this._selectionChangedHandlerForDownButton = new SelectionChangedHandler(){

            protected boolean doHandleSelection(ISelection selection_p) {
                boolean result = false;
                int selectionIndex = OrderedListViewer.this.getSelectionIndex();
                result = OrderedListViewer.this.getElementCount() - 1 != selectionIndex;
                return result;
            }
        };
    }

    protected int getSelectionIndex() {
        int selectionIndex = -1;
        Control control = this.getUnderlyingViewerControl();
        if (control instanceof org.eclipse.swt.widgets.List) {
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)control;
            selectionIndex = list.getSelectionIndex();
        } else if (control instanceof Table) {
            Table table = (Table)control;
            selectionIndex = table.getSelectionIndex();
        }
        return selectionIndex;
    }

    protected int getElementCount() {
        int itemCount = -1;
        Control control = this.getUnderlyingViewerControl();
        if (control instanceof org.eclipse.swt.widgets.List) {
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)control;
            itemCount = list.getItemCount();
        } else if (control instanceof Table) {
            Table table = (Table)control;
            itemCount = table.getItemCount();
        }
        return itemCount;
    }

    protected Control getUnderlyingViewerControl() {
        return this.getDecoratedViewer().getControl();
    }

    @Override
    protected AbstractViewerWithButtons.ButtonData[] createButtonData() {
        this.initializeSelectionChangedHandlers();
        List<AbstractViewerWithButtons.ButtonData> buttonData = this.createExtraButtonData();
        buttonData.add(new AbstractViewerWithButtons.ButtonData(__buttonsLabels[0], __buttonsStyles[0], UP_BUTTON_DATA, this._selectionChangedHandlerForUpButton));
        buttonData.add(new AbstractViewerWithButtons.ButtonData(__buttonsLabels[1], __buttonsStyles[1], DOWN_BUTTON_DATA, this._selectionChangedHandlerForDownButton));
        return buttonData.toArray(new AbstractViewerWithButtons.ButtonData[buttonData.size()]);
    }

    protected List<AbstractViewerWithButtons.ButtonData> createExtraButtonData() {
        return new ArrayList<AbstractViewerWithButtons.ButtonData>(0);
    }

    @Override
    protected StructuredViewer createViewer(Composite composite_p) {
        TableViewer listViewer = new TableViewer(composite_p, 2820);
        Control control = listViewer.getControl();
        GridData gridData = new GridData(4, 4, true, true);
        control.setLayoutData((Object)gridData);
        return listViewer;
    }
}

