/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.text.MessageFormat;
import java.util.StringTokenizer;

public class StringHelper {
    private static final String REGEXP_NON_WORD_CHARACTERS = "[^a-zA-Z0-9]";

    public static String formatMessage(String message_p, Object[] arguments_p) {
        MessageFormat formatter = new MessageFormat(message_p);
        return formatter.format(arguments_p);
    }

    public static String toLowerFirst(String source_p) {
        StringBuffer result = new StringBuffer(source_p);
        String firstCharacter = source_p.substring(0, 1).toLowerCase();
        result.setCharAt(0, firstCharacter.charAt(0));
        return result.toString();
    }

    public static String toUpperFirst(String source_p) {
        StringBuffer result = new StringBuffer(source_p);
        String firstCharacter = source_p.substring(0, 1).toUpperCase();
        result.setCharAt(0, firstCharacter.charAt(0));
        return result.toString();
    }

    public static String[] getTokens(String source_p, String separators_p) {
        String[] result = null;
        if (source_p == null || source_p.trim().length() == 0) {
            return result;
        }
        if (separators_p == null || separators_p.trim().length() == 0) {
            result = new String[]{source_p};
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(source_p, separators_p);
        int tokensCount = tokenizer.countTokens();
        if (tokensCount > 0) {
            result = new String[tokensCount];
            int i = 0;
            while (i < tokensCount) {
                result[i] = tokenizer.nextToken();
                ++i;
            }
        } else {
            result = new String[]{source_p};
        }
        return result;
    }

    public static String substringBefore(char separator_p, String source_p) {
        String result = null;
        if (source_p == null || source_p.trim().length() == 0) {
            return result;
        }
        int separatorPosition = source_p.lastIndexOf(separator_p);
        result = separatorPosition >= 0 ? source_p.substring(0, separatorPosition) : source_p;
        return result;
    }

    public static String substringAfter(char separator_p, String source_p) {
        String result = null;
        if (source_p == null || source_p.trim().length() == 0) {
            return result;
        }
        int separatorPosition = source_p.lastIndexOf(separator_p);
        result = separatorPosition >= 0 ? source_p.substring(separatorPosition + 1) : source_p;
        return result;
    }

    public static String createHttpUri(String relativeUri_p) {
        return "http://" + relativeUri_p;
    }

    public static String substring(String beginningDelimiter_p, String endingDelimiter_p, String content_p, boolean includeDelimiters_p) {
        int indexEndingDelimiter;
        String result = null;
        int indexBeginningDelimiter = content_p.indexOf(beginningDelimiter_p);
        if (indexBeginningDelimiter >= 0 && (indexEndingDelimiter = content_p.indexOf(endingDelimiter_p, indexBeginningDelimiter)) >= 0) {
            result = includeDelimiters_p ? content_p.substring(indexBeginningDelimiter, indexEndingDelimiter + endingDelimiter_p.length()) : content_p.substring(indexBeginningDelimiter + beginningDelimiter_p.length(), indexEndingDelimiter);
        }
        return result;
    }

    public static String replaceNonWordCharactersWithDot(String originalString_p) {
        return StringHelper.replaceNonWordCharacters(originalString_p, String.valueOf('.'));
    }

    public static String replaceNonWordCharactersWithUnderscore(String originalString_p) {
        return StringHelper.replaceNonWordCharacters(originalString_p, String.valueOf('_'));
    }

    public static String replaceNonWordCharacters(String originalString_p, String replacementString_p) {
        return originalString_p.replaceAll(REGEXP_NON_WORD_CHARACTERS, replacementString_p != null ? replacementString_p : "");
    }
}

