/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.progress;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.progress.IProgressRunnable;

public class ProgressReporter {
    public static final int TASK_DEFAULT_TICKS_COUNT = 1000;

    public static void asyncExec(final IProgressRunnable runnable_p) {
        if (runnable_p == null) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(runnable_p.getReportingTitle()){

            public IStatus runInWorkspace(IProgressMonitor monitor_p) throws CoreException {
                boolean result = ProgressReporter.syncExec(runnable_p, monitor_p);
                return result ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        job.schedule();
    }

    public static boolean syncExec(IProgressRunnable runnable_p, IProgressMonitor progressMonitor_p) {
        if (runnable_p == null) {
            return true;
        }
        IProgressMonitor progressMonitor = progressMonitor_p;
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        return runnable_p.run(progressMonitor);
    }
}

